/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextMapHolder;
import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import java.util.Objects;
import java.util.function.Function;

final class ContextPreservingFunction<T, U>
implements Function<T, U> {
    private final AsyncContextMap saved;
    private final Function<T, U> delegate;

    ContextPreservingFunction(Function<T, U> delegate, AsyncContextMap contextMap) {
        this.saved = Objects.requireNonNull(contextMap);
        this.delegate = Objects.requireNonNull(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public U apply(T t) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof AsyncContextMapHolder) {
            AsyncContextMapHolder asyncContextMapHolder = (AsyncContextMapHolder)((Object)currentThread);
            AsyncContextMap prev = asyncContextMapHolder.asyncContextMap();
            try {
                asyncContextMapHolder.asyncContextMap(this.saved);
                U u = this.delegate.apply(t);
                return u;
            }
            finally {
                asyncContextMapHolder.asyncContextMap(prev);
            }
        }
        return this.slowPath(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private U slowPath(T t) {
        AsyncContextMap prev = AsyncContextMapThreadLocal.contextThreadLocal.get();
        try {
            AsyncContextMapThreadLocal.contextThreadLocal.set(this.saved);
            U u = this.delegate.apply(t);
            return u;
        }
        finally {
            AsyncContextMapThreadLocal.contextThreadLocal.set(prev);
        }
    }
}

