/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextMapHolder;
import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import java.util.Objects;

class ContextPreservingSubscriber<T>
implements PublisherSource.Subscriber<T> {
    final AsyncContextMap saved;
    final PublisherSource.Subscriber<T> subscriber;

    ContextPreservingSubscriber(PublisherSource.Subscriber<T> subscriber, AsyncContextMap current) {
        this.subscriber = Objects.requireNonNull(subscriber);
        this.saved = Objects.requireNonNull(current);
    }

    void invokeOnSubscribe(PublisherSource.Subscription s) {
        this.subscriber.onSubscribe(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSubscribe(PublisherSource.Subscription s) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof AsyncContextMapHolder) {
            AsyncContextMapHolder asyncContextMapHolder = (AsyncContextMapHolder)((Object)currentThread);
            AsyncContextMap prev = asyncContextMapHolder.asyncContextMap();
            try {
                asyncContextMapHolder.asyncContextMap(this.saved);
                this.invokeOnSubscribe(s);
            }
            finally {
                asyncContextMapHolder.asyncContextMap(prev);
            }
        } else {
            this.onSubscribeSlowPath(s);
        }
    }

    private void onSubscribeSlowPath(PublisherSource.Subscription s) {
        AsyncContextMap prev = AsyncContextMapThreadLocal.contextThreadLocal.get();
        try {
            AsyncContextMapThreadLocal.contextThreadLocal.set(this.saved);
            this.invokeOnSubscribe(s);
        }
        finally {
            AsyncContextMapThreadLocal.contextThreadLocal.set(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onNext(T t) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof AsyncContextMapHolder) {
            AsyncContextMapHolder asyncContextMapHolder = (AsyncContextMapHolder)((Object)currentThread);
            AsyncContextMap prev = asyncContextMapHolder.asyncContextMap();
            try {
                asyncContextMapHolder.asyncContextMap(this.saved);
                this.subscriber.onNext(t);
            }
            finally {
                asyncContextMapHolder.asyncContextMap(prev);
            }
        } else {
            this.onNextSlowPath(t);
        }
    }

    private void onNextSlowPath(T t) {
        AsyncContextMap prev = AsyncContextMapThreadLocal.contextThreadLocal.get();
        try {
            AsyncContextMapThreadLocal.contextThreadLocal.set(this.saved);
            this.subscriber.onNext(t);
        }
        finally {
            AsyncContextMapThreadLocal.contextThreadLocal.set(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onError(Throwable t) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof AsyncContextMapHolder) {
            AsyncContextMapHolder asyncContextMapHolder = (AsyncContextMapHolder)((Object)currentThread);
            AsyncContextMap prev = asyncContextMapHolder.asyncContextMap();
            try {
                asyncContextMapHolder.asyncContextMap(this.saved);
                this.subscriber.onError(t);
            }
            finally {
                asyncContextMapHolder.asyncContextMap(prev);
            }
        } else {
            this.onErrorSlowPath(t);
        }
    }

    private void onErrorSlowPath(Throwable t) {
        AsyncContextMap prev = AsyncContextMapThreadLocal.contextThreadLocal.get();
        try {
            AsyncContextMapThreadLocal.contextThreadLocal.set(this.saved);
            this.subscriber.onError(t);
        }
        finally {
            AsyncContextMapThreadLocal.contextThreadLocal.set(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onComplete() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof AsyncContextMapHolder) {
            AsyncContextMapHolder asyncContextMapHolder = (AsyncContextMapHolder)((Object)currentThread);
            AsyncContextMap prev = asyncContextMapHolder.asyncContextMap();
            try {
                asyncContextMapHolder.asyncContextMap(this.saved);
                this.subscriber.onComplete();
            }
            finally {
                asyncContextMapHolder.asyncContextMap(prev);
            }
        } else {
            this.onCompleteSlowPath();
        }
    }

    private void onCompleteSlowPath() {
        AsyncContextMap prev = AsyncContextMapThreadLocal.contextThreadLocal.get();
        try {
            AsyncContextMapThreadLocal.contextThreadLocal.set(this.saved);
            this.subscriber.onComplete();
        }
        finally {
            AsyncContextMapThreadLocal.contextThreadLocal.set(prev);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.subscriber + ')';
    }
}

