/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeSingle;
import io.servicetalk.concurrent.api.AbstractSynchronousSingleOperator;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.MergedExecutors;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.concurrent.internal.SubscriberUtils;

final class PublishAndSubscribeOnSingles {
    private PublishAndSubscribeOnSingles() {
    }

    static <T> void deliverOnSubscribeAndOnError(SingleSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider, Throwable cause) {
        SubscriberUtils.deliverErrorFromSource((SingleSource.Subscriber)signalOffloader.offloadSubscriber(contextProvider.wrapSingleSubscriber(subscriber, contextMap)), (Throwable)cause);
    }

    static <T> Single<T> publishAndSubscribeOn(Single<T> original, Executor executor) {
        return original.executor() == executor ? original : new PublishAndSubscribeOn(executor, original);
    }

    static <T> Single<T> publishAndSubscribeOnOverride(Single<T> original, Executor executor) {
        return original.executor() == executor ? original : new PublishAndSubscribeOnOverride(original, executor);
    }

    static <T> Single<T> publishOn(Single<T> original, Executor executor) {
        return original.executor() == executor ? original : new PublishOn(executor, original);
    }

    static <T> Single<T> publishOnOverride(Single<T> original, Executor executor) {
        return original.executor() == executor ? original : new PublishOnOverride(original, executor);
    }

    static <T> Single<T> subscribeOn(Single<T> original, Executor executor) {
        return original.executor() == executor ? original : new SubscribeOn(executor, original);
    }

    static <T> Single<T> subscribeOnOverride(Single<T> original, Executor executor) {
        return original.executor() == executor ? original : new SubscribeOnOverride(original, executor);
    }

    private static final class SubscribeOnOverride<T>
    extends AbstractSynchronousSingleOperator<T, T> {
        SubscribeOnOverride(Single<T> original, Executor executor) {
            super(original, MergedExecutors.mergeAndOffloadSubscribe(original.executor(), executor));
        }

        @Override
        public SingleSource.Subscriber<? super T> apply(SingleSource.Subscriber<? super T> subscriber) {
            return subscriber;
        }
    }

    private static final class SubscribeOn<T>
    extends AbstractNoHandleSubscribeSingle<T> {
        private final Single<T> original;

        SubscribeOn(Executor executor, Single<T> original) {
            super(MergedExecutors.mergeAndOffloadSubscribe(original.executor(), executor));
            this.original = original;
        }

        @Override
        void handleSubscribe(SingleSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            this.original.subscribeWithSharedContext(subscriber, contextProvider);
        }
    }

    private static final class PublishOnOverride<T>
    extends AbstractSynchronousSingleOperator<T, T> {
        PublishOnOverride(Single<T> original, Executor executor) {
            super(original, MergedExecutors.mergeAndOffloadPublish(original.executor(), executor));
        }

        @Override
        public SingleSource.Subscriber<? super T> apply(SingleSource.Subscriber<? super T> subscriber) {
            return subscriber;
        }
    }

    private static class PublishOn<T>
    extends AbstractNoHandleSubscribeSingle<T> {
        private final Single<T> original;

        PublishOn(Executor executor, Single<T> original) {
            super(MergedExecutors.mergeAndOffloadPublish(original.executor(), executor));
            this.original = original;
        }

        @Override
        void handleSubscribe(SingleSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            this.original.subscribeWithSharedContext(signalOffloader.offloadSubscriber(contextProvider.wrapSingleSubscriber(subscriber, contextMap)), contextProvider);
        }
    }

    private static final class PublishAndSubscribeOnOverride<T>
    extends AbstractSynchronousSingleOperator<T, T> {
        PublishAndSubscribeOnOverride(Single<T> original, Executor executor) {
            super(original, executor);
        }

        @Override
        public SingleSource.Subscriber<? super T> apply(SingleSource.Subscriber<? super T> subscriber) {
            return subscriber;
        }
    }

    private static final class PublishAndSubscribeOn<T>
    extends AbstractNoHandleSubscribeSingle<T> {
        private final Single<T> original;

        PublishAndSubscribeOn(Executor executor, Single<T> original) {
            super(executor);
            this.original = original;
        }

        @Override
        void handleSubscribe(SingleSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            this.original.subscribeWithSharedContext(signalOffloader.offloadSubscriber(contextProvider.wrapSingleSubscriber(subscriber, contextMap)), contextProvider);
        }
    }
}

