/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AfterFinallyPublisher;
import io.servicetalk.concurrent.api.AfterSubscriberPublisher;
import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.BeforeFinallyPublisher;
import io.servicetalk.concurrent.api.BeforeSubscriberPublisher;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.BiIntPredicate;
import io.servicetalk.concurrent.api.BufferStrategy;
import io.servicetalk.concurrent.api.CloseableIteratorAsInputStream;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ConcatPublisher;
import io.servicetalk.concurrent.api.EmptyPublisher;
import io.servicetalk.concurrent.api.ErrorPublisher;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.FilterPublisher;
import io.servicetalk.concurrent.api.ForEachSubscriber;
import io.servicetalk.concurrent.api.FromArrayPublisher;
import io.servicetalk.concurrent.api.FromBlockingIterablePublisher;
import io.servicetalk.concurrent.api.FromInputStreamPublisher;
import io.servicetalk.concurrent.api.FromIterablePublisher;
import io.servicetalk.concurrent.api.FromSingleItemPublisher;
import io.servicetalk.concurrent.api.GroupedPublisher;
import io.servicetalk.concurrent.api.LiftAsynchronousPublisherOperator;
import io.servicetalk.concurrent.api.LiftSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.LiftSynchronousPublisherToSingle;
import io.servicetalk.concurrent.api.MapPublisher;
import io.servicetalk.concurrent.api.MulticastPublisher;
import io.servicetalk.concurrent.api.NeverPublisher;
import io.servicetalk.concurrent.api.PubCompletableOrError;
import io.servicetalk.concurrent.api.PubFirstOrError;
import io.servicetalk.concurrent.api.PubToCompletableIgnore;
import io.servicetalk.concurrent.api.PubToSingleFirstOrElse;
import io.servicetalk.concurrent.api.PublishAndSubscribeOnPublishers;
import io.servicetalk.concurrent.api.PublisherAsBlockingIterable;
import io.servicetalk.concurrent.api.PublisherBuffer;
import io.servicetalk.concurrent.api.PublisherConcatMapIterable;
import io.servicetalk.concurrent.api.PublisherConcatWithCompletable;
import io.servicetalk.concurrent.api.PublisherConcatWithSingle;
import io.servicetalk.concurrent.api.PublisherDefer;
import io.servicetalk.concurrent.api.PublisherDoOnUtils;
import io.servicetalk.concurrent.api.PublisherFlatMapMerge;
import io.servicetalk.concurrent.api.PublisherFlatMapSingle;
import io.servicetalk.concurrent.api.PublisherGroupBy;
import io.servicetalk.concurrent.api.PublisherGroupToMany;
import io.servicetalk.concurrent.api.PublisherOperator;
import io.servicetalk.concurrent.api.PublisherSubscribeShareContext;
import io.servicetalk.concurrent.api.PublisherToSingleOperator;
import io.servicetalk.concurrent.api.RangeIntPublisher;
import io.servicetalk.concurrent.api.RedoPublisher;
import io.servicetalk.concurrent.api.RedoWhenPublisher;
import io.servicetalk.concurrent.api.ReduceSingle;
import io.servicetalk.concurrent.api.ResumePublisher;
import io.servicetalk.concurrent.api.RunnableTerminalSignalConsumer;
import io.servicetalk.concurrent.api.ScanWithMapper;
import io.servicetalk.concurrent.api.ScanWithPublisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.TakeNPublisher;
import io.servicetalk.concurrent.api.TakeUntilPublisher;
import io.servicetalk.concurrent.api.TakeWhilePublisher;
import io.servicetalk.concurrent.api.TerminalSignalConsumer;
import io.servicetalk.concurrent.api.TimeoutPublisher;
import io.servicetalk.concurrent.api.WhenSubscriptionPublisher;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.concurrent.internal.SignalOffloaders;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Publisher<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Publisher.class);
    private final io.servicetalk.concurrent.api.Executor executor;
    private final boolean shareContextOnSubscribe;

    protected Publisher() {
        this(Executors.immediate());
    }

    Publisher(io.servicetalk.concurrent.api.Executor executor) {
        this(executor, false);
    }

    Publisher(io.servicetalk.concurrent.api.Executor executor, boolean shareContextOnSubscribe) {
        this.executor = Objects.requireNonNull(executor);
        this.shareContextOnSubscribe = shareContextOnSubscribe;
    }

    public final <R> Publisher<R> map(Function<? super T, ? extends R> mapper) {
        return new MapPublisher<R, T>(this, mapper, this.executor);
    }

    public final Publisher<T> filter(Predicate<? super T> predicate) {
        return new FilterPublisher<T>(this, predicate, this.executor);
    }

    public final <R> Publisher<R> scanWith(Supplier<R> initial, BiFunction<R, ? super T, R> accumulator) {
        return new ScanWithPublisher<T, R>(this, initial, accumulator, this.executor);
    }

    public final <R> Publisher<R> scanWith(Supplier<? extends ScanWithMapper<? super T, ? extends R>> mapperSupplier) {
        return new ScanWithPublisher(this, mapperSupplier, this.executor);
    }

    public final Publisher<T> recoverWith(Function<Throwable, ? extends Publisher<? extends T>> nextFactory) {
        return new ResumePublisher(this, nextFactory, this.executor);
    }

    public final <R> Publisher<R> flatMapMerge(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return new PublisherFlatMapMerge(this, mapper, false, this.executor);
    }

    public final <R> Publisher<R> flatMapMerge(Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency) {
        return new PublisherFlatMapMerge(this, mapper, false, maxConcurrency, this.executor);
    }

    public final <R> Publisher<R> flatMapMergeDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return new PublisherFlatMapMerge(this, mapper, true, this.executor);
    }

    public final <R> Publisher<R> flatMapMergeDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency) {
        return new PublisherFlatMapMerge(this, mapper, true, maxConcurrency, this.executor);
    }

    public final <R> Publisher<R> flatMapMergeDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int maxDelayedErrorsHint) {
        if (maxDelayedErrorsHint <= 0) {
            throw new IllegalArgumentException("maxDelayedErrorsHint " + maxDelayedErrorsHint + " (expected >0)");
        }
        return new PublisherFlatMapMerge(this, mapper, maxDelayedErrorsHint, maxConcurrency, this.executor);
    }

    public final <R> Publisher<R> flatMapMergeSingle(Function<? super T, ? extends Single<? extends R>> mapper) {
        return new PublisherFlatMapSingle(this, mapper, false, this.executor);
    }

    public final <R> Publisher<R> flatMapMergeSingle(Function<? super T, ? extends Single<? extends R>> mapper, int maxConcurrency) {
        return new PublisherFlatMapSingle(this, mapper, false, maxConcurrency, this.executor);
    }

    public final <R> Publisher<R> flatMapMergeSingleDelayError(Function<? super T, ? extends Single<? extends R>> mapper) {
        return new PublisherFlatMapSingle(this, mapper, true, this.executor);
    }

    public final <R> Publisher<R> flatMapMergeSingleDelayError(Function<? super T, ? extends Single<? extends R>> mapper, int maxConcurrency) {
        return new PublisherFlatMapSingle(this, mapper, true, maxConcurrency, this.executor);
    }

    public final <R> Publisher<R> flatMapMergeSingleDelayError(Function<? super T, ? extends Single<? extends R>> mapper, int maxConcurrency, int maxDelayedErrorsHint) {
        if (maxDelayedErrorsHint <= 0) {
            throw new IllegalArgumentException("maxDelayedErrorsHint " + maxDelayedErrorsHint + " (expected >0)");
        }
        return new PublisherFlatMapSingle(this, mapper, maxDelayedErrorsHint, maxConcurrency, this.executor);
    }

    public final Completable flatMapCompletable(Function<? super T, ? extends Completable> mapper) {
        return this.flatMapMergeSingle(t -> ((Completable)mapper.apply(t)).toSingle()).ignoreElements();
    }

    public final Completable flatMapCompletable(Function<? super T, ? extends Completable> mapper, int maxConcurrency) {
        return this.flatMapMergeSingle(t -> ((Completable)mapper.apply(t)).toSingle(), maxConcurrency).ignoreElements();
    }

    public final Completable flatMapCompletableDelayError(Function<? super T, ? extends Completable> mapper) {
        return this.flatMapMergeSingleDelayError(t -> ((Completable)mapper.apply(t)).toSingle()).ignoreElements();
    }

    public final Completable flatMapCompletableDelayError(Function<? super T, ? extends Completable> mapper, int maxConcurrency) {
        return this.flatMapMergeSingleDelayError(t -> ((Completable)mapper.apply(t)).toSingle(), maxConcurrency).ignoreElements();
    }

    public final Completable flatMapCompletableDelayError(Function<? super T, ? extends Completable> mapper, int maxConcurrency, int maxDelayedErrorsHint) {
        return this.flatMapMergeSingleDelayError(t -> ((Completable)mapper.apply(t)).toSingle(), maxConcurrency, maxDelayedErrorsHint).ignoreElements();
    }

    public final <R> Publisher<R> flatMapConcatIterable(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return new PublisherConcatMapIterable(this, mapper, this.executor);
    }

    public final Publisher<T> whenOnSubscribe(Consumer<? super PublisherSource.Subscription> onSubscribe) {
        return this.beforeOnSubscribe(onSubscribe);
    }

    public final Publisher<T> whenOnNext(Consumer<? super T> onNext) {
        return this.beforeOnNext(onNext);
    }

    public final Publisher<T> whenOnComplete(Runnable onComplete) {
        return this.beforeOnComplete(onComplete);
    }

    public final Publisher<T> whenOnError(Consumer<Throwable> onError) {
        return this.beforeOnError(onError);
    }

    public final Publisher<T> whenFinally(Runnable doFinally) {
        return this.beforeFinally(doFinally);
    }

    public final Publisher<T> whenFinally(TerminalSignalConsumer doFinally) {
        return this.beforeFinally(doFinally);
    }

    public final Publisher<T> whenRequest(LongConsumer onRequest) {
        return this.beforeRequest(onRequest);
    }

    public final Publisher<T> whenCancel(Runnable onCancel) {
        return this.beforeCancel(onCancel);
    }

    public final Publisher<T> idleTimeout(long duration, TimeUnit unit) {
        return new TimeoutPublisher(this, this.executor, duration, unit);
    }

    public final Publisher<T> idleTimeout(Duration duration) {
        return new TimeoutPublisher(this, this.executor, duration);
    }

    public final Publisher<T> idleTimeout(long duration, TimeUnit unit, Executor timeoutExecutor) {
        return new TimeoutPublisher(this, this.executor, duration, unit, timeoutExecutor);
    }

    public final Publisher<T> idleTimeout(Duration duration, Executor timeoutExecutor) {
        return new TimeoutPublisher(this, this.executor, duration, timeoutExecutor);
    }

    public final Publisher<T> concat(Publisher<? extends T> next) {
        return new ConcatPublisher<T>(this, next, this.executor);
    }

    public final Publisher<T> concat(Single<? extends T> next) {
        return new PublisherConcatWithSingle<T>(this, next, this.executor);
    }

    public final Publisher<T> concat(Completable next) {
        return new PublisherConcatWithCompletable(this, next, this.executor);
    }

    public final Publisher<T> retry(BiIntPredicate<Throwable> shouldRetry) {
        return new RedoPublisher(this, (retryCount, terminalNotification) -> terminalNotification.cause() != null && shouldRetry.test((int)retryCount, terminalNotification.cause()), this.executor);
    }

    public final Publisher<T> retryWhen(BiIntFunction<Throwable, ? extends Completable> retryWhen) {
        return new RedoWhenPublisher(this, (retryCount, notification) -> {
            if (notification.cause() == null) {
                return Completable.completed();
            }
            return (Completable)retryWhen.apply((int)retryCount, notification.cause());
        }, true, this.executor);
    }

    public final Publisher<T> repeat(IntPredicate shouldRepeat) {
        return new RedoPublisher(this, (repeatCount, terminalNotification) -> terminalNotification.cause() == null && shouldRepeat.test((int)repeatCount), this.executor);
    }

    public final Publisher<T> repeatWhen(IntFunction<? extends Completable> repeatWhen) {
        return new RedoWhenPublisher(this, (retryCount, notification) -> {
            if (notification.cause() != null) {
                return Completable.completed();
            }
            return (Completable)repeatWhen.apply((int)retryCount);
        }, false, this.executor);
    }

    public final Publisher<T> takeAtMost(long numElements) {
        return new TakeNPublisher(this, numElements, this.executor);
    }

    public final Publisher<T> takeWhile(Predicate<? super T> predicate) {
        return new TakeWhilePublisher<T>(this, predicate, this.executor);
    }

    public final Publisher<T> takeUntil(Completable until) {
        return new TakeUntilPublisher(this, until, this.executor);
    }

    public final <Key> Publisher<GroupedPublisher<Key, T>> groupBy(Function<? super T, ? extends Key> keySelector, int groupMaxQueueSize) {
        return new PublisherGroupBy<Key, T>(this, keySelector, groupMaxQueueSize, this.executor);
    }

    public final <Key> Publisher<GroupedPublisher<Key, T>> groupBy(Function<? super T, ? extends Key> keySelector, int groupMaxQueueSize, int expectedGroupCountHint) {
        return new PublisherGroupBy<Key, T>(this, keySelector, groupMaxQueueSize, expectedGroupCountHint, this.executor);
    }

    public final <Key> Publisher<GroupedPublisher<Key, T>> groupToMany(Function<? super T, ? extends Iterator<? extends Key>> keySelector, int groupMaxQueueSize) {
        return new PublisherGroupToMany(this, keySelector, groupMaxQueueSize, this.executor);
    }

    public final <Key> Publisher<GroupedPublisher<Key, T>> groupToMany(Function<? super T, ? extends Iterator<? extends Key>> keySelector, int groupMaxQueueSize, int expectedGroupCountHint) {
        return new PublisherGroupToMany(this, keySelector, groupMaxQueueSize, expectedGroupCountHint, this.executor);
    }

    public final Publisher<T> multicastToExactly(int expectedSubscribers) {
        return new MulticastPublisher(this, expectedSubscribers, this.executor);
    }

    public final Publisher<T> multicastToExactly(int expectedSubscribers, int maxQueueSize) {
        return new MulticastPublisher(this, expectedSubscribers, maxQueueSize, this.executor);
    }

    public final <BC extends BufferStrategy.Accumulator<T, B>, B> Publisher<B> buffer(BufferStrategy<T, BC, B> strategy) {
        return new PublisherBuffer<T, B>(this, this.executor, strategy);
    }

    public final Publisher<T> beforeOnSubscribe(Consumer<? super PublisherSource.Subscription> onSubscribe) {
        return this.beforeSubscriber(PublisherDoOnUtils.doOnSubscribeSupplier(onSubscribe));
    }

    public final Publisher<T> beforeOnNext(Consumer<? super T> onNext) {
        return this.beforeSubscriber(PublisherDoOnUtils.doOnNextSupplier(onNext));
    }

    public final Publisher<T> beforeOnError(Consumer<Throwable> onError) {
        return this.beforeSubscriber(PublisherDoOnUtils.doOnErrorSupplier(onError));
    }

    public final Publisher<T> beforeOnComplete(Runnable onComplete) {
        return this.beforeSubscriber(PublisherDoOnUtils.doOnCompleteSupplier(onComplete));
    }

    public final Publisher<T> beforeRequest(LongConsumer onRequest) {
        return this.beforeSubscription(PublisherDoOnUtils.doOnRequestSupplier(onRequest));
    }

    public final Publisher<T> beforeCancel(Runnable onCancel) {
        return this.beforeSubscription(PublisherDoOnUtils.doOnCancelSupplier(onCancel));
    }

    public final Publisher<T> beforeFinally(Runnable doFinally) {
        return this.beforeFinally(new RunnableTerminalSignalConsumer(doFinally));
    }

    public final Publisher<T> beforeFinally(TerminalSignalConsumer doFinally) {
        return new BeforeFinallyPublisher(this, doFinally, this.executor);
    }

    public final Publisher<T> beforeSubscriber(Supplier<? extends PublisherSource.Subscriber<? super T>> subscriberSupplier) {
        return new BeforeSubscriberPublisher(this, subscriberSupplier, this.executor);
    }

    public final Publisher<T> beforeSubscription(Supplier<? extends PublisherSource.Subscription> subscriptionSupplier) {
        return new WhenSubscriptionPublisher(this, subscriptionSupplier, true, this.executor);
    }

    public final Publisher<T> afterOnSubscribe(Consumer<? super PublisherSource.Subscription> onSubscribe) {
        return this.afterSubscriber(PublisherDoOnUtils.doOnSubscribeSupplier(onSubscribe));
    }

    public final Publisher<T> afterOnNext(Consumer<? super T> onNext) {
        return this.afterSubscriber(PublisherDoOnUtils.doOnNextSupplier(onNext));
    }

    public final Publisher<T> afterOnError(Consumer<Throwable> onError) {
        return this.afterSubscriber(PublisherDoOnUtils.doOnErrorSupplier(onError));
    }

    public final Publisher<T> afterOnComplete(Runnable onComplete) {
        return this.afterSubscriber(PublisherDoOnUtils.doOnCompleteSupplier(onComplete));
    }

    public final Publisher<T> afterRequest(LongConsumer onRequest) {
        return this.afterSubscription(PublisherDoOnUtils.doOnRequestSupplier(onRequest));
    }

    public final Publisher<T> afterCancel(Runnable onCancel) {
        return this.afterSubscription(PublisherDoOnUtils.doOnCancelSupplier(onCancel));
    }

    public final Publisher<T> afterFinally(Runnable doFinally) {
        return this.afterFinally(new RunnableTerminalSignalConsumer(doFinally));
    }

    public final Publisher<T> afterFinally(TerminalSignalConsumer doFinally) {
        return new AfterFinallyPublisher(this, doFinally, this.executor);
    }

    public final Publisher<T> afterSubscriber(Supplier<? extends PublisherSource.Subscriber<? super T>> subscriberSupplier) {
        return new AfterSubscriberPublisher(this, subscriberSupplier, this.executor);
    }

    public final Publisher<T> whenSubscriber(Supplier<? extends PublisherSource.Subscriber<? super T>> subscriberSupplier) {
        return this.beforeSubscriber(subscriberSupplier);
    }

    public final Publisher<T> afterSubscription(Supplier<? extends PublisherSource.Subscription> subscriptionSupplier) {
        return new WhenSubscriptionPublisher(this, subscriptionSupplier, false, this.executor);
    }

    public final Publisher<T> whenSubscription(Supplier<? extends PublisherSource.Subscription> subscriptionSupplier) {
        return this.beforeSubscription(subscriptionSupplier);
    }

    public final Cancellable forEach(Consumer<? super T> forEach) {
        ForEachSubscriber<? super T> subscriber = new ForEachSubscriber<T>(forEach);
        this.subscribeInternal(subscriber);
        return subscriber;
    }

    public final Publisher<T> publishOn(io.servicetalk.concurrent.api.Executor executor) {
        return PublishAndSubscribeOnPublishers.publishOn(this, executor);
    }

    public final Publisher<T> publishOnOverride(io.servicetalk.concurrent.api.Executor executor) {
        return PublishAndSubscribeOnPublishers.publishOnOverride(this, executor);
    }

    public final Publisher<T> subscribeOn(io.servicetalk.concurrent.api.Executor executor) {
        return PublishAndSubscribeOnPublishers.subscribeOn(this, executor);
    }

    public final Publisher<T> subscribeOnOverride(io.servicetalk.concurrent.api.Executor executor) {
        return PublishAndSubscribeOnPublishers.subscribeOnOverride(this, executor);
    }

    public final Publisher<T> publishAndSubscribeOn(io.servicetalk.concurrent.api.Executor executor) {
        return PublishAndSubscribeOnPublishers.publishAndSubscribeOn(this, executor);
    }

    public final Publisher<T> publishAndSubscribeOnOverride(io.servicetalk.concurrent.api.Executor executor) {
        return PublishAndSubscribeOnPublishers.publishAndSubscribeOnOverride(this, executor);
    }

    public final Publisher<T> subscribeShareContext() {
        return new PublisherSubscribeShareContext(this);
    }

    public final <R> Publisher<R> liftSync(PublisherOperator<? super T, ? extends R> operator) {
        return new LiftSynchronousPublisherOperator<T, R>(this, operator, this.executor);
    }

    public final <R> Single<R> liftSyncToSingle(PublisherToSingleOperator<? super T, ? extends R> operator) {
        return new LiftSynchronousPublisherToSingle<T, R>(this, operator);
    }

    public final <R> Publisher<R> liftAsync(PublisherOperator<? super T, ? extends R> operator) {
        return new LiftAsynchronousPublisherOperator<T, R>(this, operator, this.executor);
    }

    public final Single<T> firstOrElse(Supplier<T> defaultValueSupplier) {
        return new PubToSingleFirstOrElse<T>(this, defaultValueSupplier);
    }

    public final Single<T> firstOrError() {
        return new PubFirstOrError(this);
    }

    public final Completable ignoreElements() {
        return new PubToCompletableIgnore(this);
    }

    public final Completable completableOrError() {
        return new PubCompletableOrError(this);
    }

    public final <R> Single<R> collect(Supplier<? extends R> resultFactory, BiFunction<? super R, ? super T, R> collector) {
        return new ReduceSingle<R, T>(this, resultFactory, collector);
    }

    public final Future<Collection<T>> toFuture() {
        return this.toFuture(ArrayList::new, (list, next) -> {
            list.add(next);
            return list;
        });
    }

    public final <R> Future<R> toFuture(Supplier<? extends R> resultFactory, BiFunction<? super R, ? super T, R> reducer) {
        return this.collect(resultFactory, reducer).toFuture();
    }

    public final CompletionStage<Collection<T>> toCompletionStage() {
        return this.toCompletionStage(ArrayList::new, (list, next) -> {
            list.add(next);
            return list;
        });
    }

    public final <R> CompletionStage<R> toCompletionStage(Supplier<? extends R> resultFactory, BiFunction<? super R, ? super T, R> reducer) {
        return this.collect(resultFactory, reducer).toCompletionStage();
    }

    public final InputStream toInputStream(Function<? super T, byte[]> serializer) {
        return new CloseableIteratorAsInputStream<T>(new PublisherAsBlockingIterable(this).iterator(), serializer);
    }

    public final InputStream toInputStream(Function<? super T, byte[]> serializer, int queueCapacity) {
        return new CloseableIteratorAsInputStream<T>(new PublisherAsBlockingIterable(this, queueCapacity).iterator(), serializer);
    }

    public final BlockingIterable<T> toIterable() {
        return new PublisherAsBlockingIterable(this);
    }

    public final BlockingIterable<T> toIterable(int queueCapacityHint) {
        return new PublisherAsBlockingIterable(this, queueCapacityHint);
    }

    protected final void subscribeInternal(PublisherSource.Subscriber<? super T> subscriber) {
        AsyncContextProvider provider = AsyncContext.provider();
        this.subscribeWithContext(subscriber, provider, this.shareContextOnSubscribe ? provider.contextMap() : provider.contextMap().copy());
    }

    protected abstract void handleSubscribe(PublisherSource.Subscriber<? super T> var1);

    public static <T> Publisher<T> from(@Nullable T value) {
        return new FromSingleItemPublisher<T>(value);
    }

    @SafeVarargs
    public static <T> Publisher<T> from(T ... values) {
        return new FromArrayPublisher<T>(values);
    }

    public static <T> Publisher<T> fromIterable(Iterable<? extends T> iterable) {
        return new FromIterablePublisher<T>(iterable);
    }

    public static <T> Publisher<T> fromBlockingIterable(BlockingIterable<? extends T> iterable, LongSupplier timeoutSupplier, TimeUnit unit) {
        return new FromBlockingIterablePublisher<T>(iterable, timeoutSupplier, unit);
    }

    public static Publisher<byte[]> fromInputStream(InputStream stream) {
        return new FromInputStreamPublisher(stream);
    }

    public static Publisher<Integer> range(int begin, int end) {
        return new RangeIntPublisher(begin, end);
    }

    public static Publisher<Integer> range(int begin, int end, int stride) {
        return new RangeIntPublisher(begin, end, stride);
    }

    public static <T> Publisher<T> empty() {
        return EmptyPublisher.emptyPublisher();
    }

    public static <T> Publisher<T> never() {
        return NeverPublisher.neverPublisher();
    }

    public static <T> Publisher<T> failed(Throwable cause) {
        return new ErrorPublisher(cause);
    }

    public static <T> Publisher<T> defer(Supplier<? extends Publisher<? extends T>> publisherSupplier) {
        return new PublisherDefer(publisherSupplier);
    }

    final void subscribeWithSharedContext(PublisherSource.Subscriber<? super T> subscriber) {
        AsyncContextProvider provider = AsyncContext.provider();
        this.subscribeWithContext(subscriber, provider, provider.contextMap());
    }

    final void delegateSubscribe(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        this.handleSubscribe(subscriber, signalOffloader, contextMap, contextProvider);
    }

    private void subscribeWithContext(PublisherSource.Subscriber<? super T> subscriber, AsyncContextProvider provider, AsyncContextMap contextMap) {
        PublisherSource.Subscriber offloadedSubscriber;
        SignalOffloader signalOffloader;
        Objects.requireNonNull(subscriber);
        try {
            signalOffloader = SignalOffloaders.newOffloaderFor((Executor)this.executor);
            offloadedSubscriber = signalOffloader.offloadSubscription(provider.wrapSubscription(subscriber, contextMap));
        }
        catch (Throwable t) {
            SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)t);
            return;
        }
        signalOffloader.offloadSubscribe(offloadedSubscriber, provider.wrapConsumer(s -> this.handleSubscribe((PublisherSource.Subscriber<? super T>)s, signalOffloader, contextMap, provider), contextMap));
    }

    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        try {
            PublisherSource.Subscriber offloaded = signalOffloader.offloadSubscriber(contextProvider.wrapPublisherSubscriber(subscriber, contextMap));
            this.handleSubscribe(offloaded);
        }
        catch (Throwable t) {
            LOGGER.warn("Unexpected exception from subscribe(), assuming no interaction with the Subscriber.", t);
            SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)t);
        }
    }

    final io.servicetalk.concurrent.api.Executor executor() {
        return this.executor;
    }

    static {
        AsyncContext.autoEnable();
    }
}

