/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.MergedCancellableWithSubscription;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.RedoPublisher;
import io.servicetalk.concurrent.api.SequentialSubscription;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.concurrent.internal.TerminalNotification;
import java.util.Objects;
import java.util.function.BiFunction;

final class RedoWhenPublisher<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private final Publisher<T> original;
    private final BiFunction<Integer, TerminalNotification, Completable> shouldRedo;
    private final boolean forRetry;

    RedoWhenPublisher(Publisher<T> original, BiFunction<Integer, TerminalNotification, Completable> shouldRedo, boolean forRetry, Executor executor) {
        super(executor);
        this.original = original;
        this.shouldRedo = shouldRedo;
        this.forRetry = forRetry;
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new RedoSubscriber<T>(new SequentialSubscription(), 0, subscriber, contextMap.copy(), contextProvider, this, signalOffloader), signalOffloader, contextMap, contextProvider);
    }

    private static final class RedoSubscriber<T>
    extends RedoPublisher.AbstractRedoSubscriber<T> {
        private final SequentialCancellable cancellable;
        private final RedoWhenPublisher<T> redoPublisher;
        private final AsyncContextMap contextMap;
        private final AsyncContextProvider contextProvider;
        private final SignalOffloader signalOffloader;

        RedoSubscriber(SequentialSubscription subscription, int redoCount, PublisherSource.Subscriber<? super T> subscriber, AsyncContextMap contextMap, AsyncContextProvider contextProvider, RedoWhenPublisher<T> redoPublisher, SignalOffloader signalOffloader) {
            super(subscription, redoCount, subscriber);
            this.redoPublisher = redoPublisher;
            this.contextMap = contextMap;
            this.contextProvider = contextProvider;
            this.signalOffloader = signalOffloader;
            this.cancellable = new SequentialCancellable();
        }

        public void onNext(T t) {
            this.subscription.itemReceived();
            this.subscriber.onNext(t);
        }

        public void onError(Throwable t) {
            if (!((RedoWhenPublisher)this.redoPublisher).forRetry) {
                this.subscriber.onError(t);
                return;
            }
            TerminalNotification terminalNotification = TerminalNotification.error((Throwable)t);
            this.redoIfRequired(terminalNotification);
        }

        public void onComplete() {
            if (((RedoWhenPublisher)this.redoPublisher).forRetry) {
                this.subscriber.onComplete();
                return;
            }
            this.redoIfRequired(TerminalNotification.complete());
        }

        @Override
        PublisherSource.Subscription decorate(PublisherSource.Subscription s) {
            return new MergedCancellableWithSubscription(s, (Cancellable)this.cancellable);
        }

        private void redoIfRequired(TerminalNotification terminalNotification) {
            Completable redoDecider;
            try {
                redoDecider = (Completable)Objects.requireNonNull(((RedoWhenPublisher)this.redoPublisher).shouldRedo.apply(this.redoCount + 1, terminalNotification));
            }
            catch (Throwable cause) {
                Throwable originalCause = terminalNotification.cause();
                if (originalCause != null) {
                    cause.addSuppressed(originalCause);
                }
                this.subscriber.onError(cause);
                return;
            }
            redoDecider.subscribeInternal(new CompletableSource.Subscriber(){

                public void onSubscribe(Cancellable completableCancellable) {
                    cancellable.nextCancellable(completableCancellable);
                }

                public void onComplete() {
                    redoPublisher.original.delegateSubscribe(new RedoSubscriber(subscription, redoCount + 1, subscriber, contextMap.copy(), contextProvider, redoPublisher, signalOffloader), signalOffloader, contextMap, contextProvider);
                }

                public void onError(Throwable t) {
                    if (!redoPublisher.forRetry) {
                        subscriber.onComplete();
                    } else {
                        subscriber.onError(t);
                    }
                }
            });
        }
    }
}

