/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.SequentialSubscription;
import io.servicetalk.concurrent.internal.SignalOffloader;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

final class ResumePublisher<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private final Publisher<T> original;
    private final Function<Throwable, ? extends Publisher<? extends T>> nextFactory;

    ResumePublisher(Publisher<T> original, Function<Throwable, ? extends Publisher<? extends T>> nextFactory, Executor executor) {
        super(executor);
        this.original = original;
        this.nextFactory = Objects.requireNonNull(nextFactory);
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ResumeSubscriber<T>(subscriber, this.nextFactory, signalOffloader, contextMap, contextProvider), signalOffloader, contextMap, contextProvider);
    }

    private static final class ResumeSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<? super T> subscriber;
        private final SignalOffloader signalOffloader;
        private final AsyncContextMap contextMap;
        private final AsyncContextProvider contextProvider;
        @Nullable
        private SequentialSubscription sequentialSubscription;
        @Nullable
        private Function<Throwable, ? extends Publisher<? extends T>> nextFactory;

        ResumeSubscriber(PublisherSource.Subscriber<? super T> subscriber, Function<Throwable, ? extends Publisher<? extends T>> nextFactory, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            this.subscriber = subscriber;
            this.nextFactory = nextFactory;
            this.signalOffloader = signalOffloader;
            this.contextMap = contextMap;
            this.contextProvider = contextProvider;
        }

        public void onSubscribe(PublisherSource.Subscription s) {
            if (this.sequentialSubscription == null) {
                this.sequentialSubscription = new SequentialSubscription(s);
                this.subscriber.onSubscribe((PublisherSource.Subscription)this.sequentialSubscription);
            } else {
                this.nextFactory = null;
                this.sequentialSubscription.switchTo(s);
            }
        }

        public void onNext(T t) {
            assert (this.sequentialSubscription != null);
            this.sequentialSubscription.itemReceived();
            this.subscriber.onNext(t);
        }

        public void onError(Throwable t) {
            Publisher<T> next;
            if (this.nextFactory == null) {
                this.subscriber.onError(t);
                return;
            }
            try {
                next = Objects.requireNonNull(this.nextFactory.apply(t));
            }
            catch (Throwable throwable) {
                throwable.addSuppressed(t);
                this.subscriber.onError(throwable);
                return;
            }
            PublisherSource.Subscriber offloadedSubscriber = this.signalOffloader.offloadSubscriber(this.contextProvider.wrapPublisherSubscriber(this, this.contextMap));
            next.subscribeInternal(offloadedSubscriber);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}

