/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeCompletable;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SignalOffloader;
import java.util.Objects;
import javax.annotation.Nullable;

final class SingleToCompletable<T>
extends AbstractNoHandleSubscribeCompletable {
    private final Single<T> original;

    SingleToCompletable(Single<T> original, Executor executor) {
        super(executor);
        this.original = Objects.requireNonNull(original);
    }

    @Override
    void handleSubscribe(final CompletableSource.Subscriber subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new SingleSource.Subscriber<T>(){

            public void onSubscribe(Cancellable cancellable) {
                subscriber.onSubscribe(cancellable);
            }

            public void onSuccess(@Nullable T result) {
                subscriber.onComplete();
            }

            public void onError(Throwable t) {
                subscriber.onError(t);
            }
        }, signalOffloader, contextMap, contextProvider);
    }
}

