/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

abstract class SourceToFuture<T>
implements Future<T> {
    static final Object NULL = new Object();
    private static final Object CANCELLED = new Object();
    private static final AtomicReferenceFieldUpdater<SourceToFuture, Object> valueUpdater = AtomicReferenceFieldUpdater.newUpdater(SourceToFuture.class, Object.class, "value");
    private final DelayedCancellable cancellable = new DelayedCancellable();
    private final CountDownLatch latch = new CountDownLatch(1);
    @Nullable
    private volatile Object value;

    private SourceToFuture() {
    }

    public final void onSubscribe(Cancellable cancellable) {
        this.cancellable.delayedCancellable(cancellable);
    }

    final void setValue(@Nullable Object value) {
        if (valueUpdater.compareAndSet(this, null, value)) {
            this.latch.countDown();
        }
    }

    public final void onError(Throwable t) {
        this.setValue(Objects.requireNonNull(t));
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        if (valueUpdater.compareAndSet(this, null, CANCELLED)) {
            this.cancellable.cancel();
            this.latch.countDown();
            return true;
        }
        return false;
    }

    @Override
    public final boolean isCancelled() {
        return this.value == CANCELLED;
    }

    @Override
    public final boolean isDone() {
        return this.value != null;
    }

    @Override
    @Nullable
    public final T get() throws InterruptedException, ExecutionException {
        Object value = this.value;
        if (value == null) {
            this.latch.await();
            return this.reportGet(this.value);
        }
        return this.reportGet(value);
    }

    @Override
    @Nullable
    public final T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object value = this.value;
        if (value == null) {
            if (this.latch.await(timeout, unit)) {
                return this.reportGet(this.value);
            }
            throw new TimeoutException("Timed out waiting for the result");
        }
        return this.reportGet(value);
    }

    @Nullable
    private T reportGet(@Nullable Object value) throws ExecutionException {
        if (value == NULL) {
            return null;
        }
        if (value instanceof Throwable) {
            throw new ExecutionException((Throwable)value);
        }
        if (value == CANCELLED) {
            throw new CancellationException();
        }
        if (value instanceof ThrowableWrapper) {
            return (T)((ThrowableWrapper)value).unwrap();
        }
        return (T)value;
    }

    private static final class ThrowableWrapper {
        private final Object throwable;

        ThrowableWrapper(Object throwable) {
            this.throwable = throwable;
        }

        Object unwrap() {
            return this.throwable;
        }
    }

    static final class CompletableToFuture
    extends SourceToFuture<Void>
    implements CompletableSource.Subscriber {
        private CompletableToFuture() {
        }

        static Future<Void> createAndSubscribe(Completable original) {
            CompletableToFuture future = new CompletableToFuture();
            original.subscribeInternal(future);
            return future;
        }

        public void onComplete() {
            this.setValue(NULL);
        }
    }

    static final class SingleToFuture<T>
    extends SourceToFuture<T>
    implements SingleSource.Subscriber<T> {
        private SingleToFuture() {
        }

        static <T> Future<T> createAndSubscribe(Single<T> original) {
            SingleToFuture<T> future = new SingleToFuture<T>();
            original.subscribeInternal(future);
            return future;
        }

        public void onSuccess(@Nullable T result) {
            if (result == null) {
                this.setValue(NULL);
            } else if (result instanceof Throwable) {
                this.setValue(new ThrowableWrapper(result));
            } else {
                this.setValue(result);
            }
        }
    }
}

