/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.PublishAndSubscribeOnPublishers;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.ConcurrentSubscription;
import io.servicetalk.concurrent.internal.ConcurrentTerminalSubscriber;
import io.servicetalk.concurrent.internal.EmptySubscriptions;
import io.servicetalk.concurrent.internal.SignalOffloader;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

final class TimeoutPublisher<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private final Publisher<T> original;
    private final Executor timeoutExecutor;
    private final long durationNs;

    TimeoutPublisher(Publisher<T> original, io.servicetalk.concurrent.api.Executor executor, Duration duration) {
        this(original, executor, duration, (Executor)executor);
    }

    TimeoutPublisher(Publisher<T> original, io.servicetalk.concurrent.api.Executor executor, long duration, TimeUnit unit) {
        this(original, executor, duration, unit, executor);
    }

    TimeoutPublisher(Publisher<T> original, io.servicetalk.concurrent.api.Executor publisherExecutor, Duration duration, Executor timeoutExecutor) {
        this(original, publisherExecutor, duration.toNanos(), timeoutExecutor);
    }

    TimeoutPublisher(Publisher<T> original, io.servicetalk.concurrent.api.Executor publisherExecutor, long duration, TimeUnit unit, Executor timeoutExecutor) {
        this(original, publisherExecutor, unit.toNanos(duration), timeoutExecutor);
    }

    private TimeoutPublisher(Publisher<T> original, io.servicetalk.concurrent.api.Executor publisherExecutor, long durationNs, Executor timeoutExecutor) {
        super(publisherExecutor);
        this.original = Objects.requireNonNull(original);
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor);
        this.durationNs = Math.max(0L, durationNs);
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(TimeoutSubscriber.newInstance(this, subscriber, signalOffloader, contextMap, contextProvider), signalOffloader, contextMap, contextProvider);
    }

    private static final class TimeoutSubscriber<X>
    implements PublisherSource.Subscriber<X>,
    PublisherSource.Subscription,
    Runnable {
        private static final Cancellable LOCAL_IGNORE_CANCEL = () -> {};
        private static final Cancellable TIMER_PROCESSING = () -> {};
        private static final Cancellable TIMER_FIRED = () -> {};
        private static final AtomicReferenceFieldUpdater<TimeoutSubscriber, Cancellable> timerCancellableUpdater = AtomicReferenceFieldUpdater.newUpdater(TimeoutSubscriber.class, Cancellable.class, "timerCancellable");
        private static final AtomicReferenceFieldUpdater<TimeoutSubscriber, PublisherSource.Subscription> subscriptionUpdater = AtomicReferenceFieldUpdater.newUpdater(TimeoutSubscriber.class, PublisherSource.Subscription.class, "subscription");
        private final TimeoutPublisher<X> parent;
        private final ConcurrentTerminalSubscriber<? super X> target;
        private final SignalOffloader signalOffloader;
        private final AsyncContextProvider contextProvider;
        @Nullable
        private volatile PublisherSource.Subscription subscription;
        @Nullable
        private volatile Cancellable timerCancellable;
        private volatile long lastOnNextNs;

        private TimeoutSubscriber(TimeoutPublisher<X> parent, PublisherSource.Subscriber<? super X> target, SignalOffloader signalOffloader, AsyncContextProvider contextProvider) {
            this.parent = parent;
            this.target = new ConcurrentTerminalSubscriber(target);
            this.signalOffloader = signalOffloader;
            this.contextProvider = contextProvider;
        }

        static <X> TimeoutSubscriber<X> newInstance(TimeoutPublisher<X> parent, PublisherSource.Subscriber<? super X> target, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            TimeoutSubscriber<? super X> s = new TimeoutSubscriber<X>(parent, target, signalOffloader, contextProvider);
            try {
                s.lastOnNextNs = System.nanoTime();
                timerCancellableUpdater.compareAndSet(s, null, Objects.requireNonNull(((TimeoutPublisher)parent).timeoutExecutor.schedule(s, ((TimeoutPublisher)parent).durationNs, TimeUnit.NANOSECONDS)));
            }
            catch (Throwable cause) {
                TimeoutSubscriber.handleConstructorException(s, signalOffloader, contextMap, contextProvider, cause);
            }
            return s;
        }

        public void onSubscribe(PublisherSource.Subscription s) {
            if (subscriptionUpdater.compareAndSet(this, null, (PublisherSource.Subscription)ConcurrentSubscription.wrap((PublisherSource.Subscription)s))) {
                this.target.onSubscribe((PublisherSource.Subscription)this);
            } else {
                s.cancel();
            }
        }

        public void onNext(X x) {
            this.lastOnNextNs = System.nanoTime();
            this.target.onNext(x);
        }

        public void onError(Throwable t) {
            if (this.target.processOnError(t)) {
                this.stopTimer();
            }
        }

        public void onComplete() {
            if (this.target.processOnComplete()) {
                this.stopTimer();
            }
        }

        public void request(long n) {
            PublisherSource.Subscription subscription = this.subscription;
            assert (subscription != null);
            subscription.request(n);
        }

        public void cancel() {
            PublisherSource.Subscription subscription = this.subscription;
            assert (subscription != null);
            try {
                this.stopTimer();
            }
            finally {
                subscription.cancel();
            }
        }

        @Override
        public void run() {
            Cancellable previousTimerCancellable;
            while (true) {
                if ((previousTimerCancellable = this.timerCancellable) == LOCAL_IGNORE_CANCEL || previousTimerCancellable == TIMER_FIRED) {
                    return;
                }
                if (previousTimerCancellable == TIMER_PROCESSING) {
                    if (!timerCancellableUpdater.compareAndSet(this, TIMER_PROCESSING, TIMER_FIRED)) continue;
                    return;
                }
                if (timerCancellableUpdater.compareAndSet(this, previousTimerCancellable, TIMER_PROCESSING)) break;
            }
            block3: while (true) {
                Cancellable nextTimerCancellable;
                long nextTimeoutNs;
                if ((nextTimeoutNs = ((TimeoutPublisher)this.parent).durationNs - (System.nanoTime() - this.lastOnNextNs)) <= 0L) {
                    this.offloadTimeout(new TimeoutException("timeout after " + TimeUnit.NANOSECONDS.toMillis(((TimeoutPublisher)this.parent).durationNs) + "ms"));
                    return;
                }
                try {
                    nextTimerCancellable = Objects.requireNonNull(((TimeoutPublisher)this.parent).timeoutExecutor.schedule((Runnable)this, nextTimeoutNs, TimeUnit.NANOSECONDS));
                }
                catch (Throwable cause) {
                    this.offloadTimeout(cause);
                    return;
                }
                if (timerCancellableUpdater.compareAndSet(this, previousTimerCancellable, nextTimerCancellable)) {
                    return;
                }
                while (true) {
                    if ((previousTimerCancellable = this.timerCancellable) == LOCAL_IGNORE_CANCEL) {
                        nextTimerCancellable.cancel();
                        return;
                    }
                    if (previousTimerCancellable == TIMER_FIRED) {
                        if (!timerCancellableUpdater.compareAndSet(this, TIMER_FIRED, TIMER_PROCESSING)) continue;
                        previousTimerCancellable = TIMER_PROCESSING;
                        continue block3;
                    }
                    if (timerCancellableUpdater.compareAndSet(this, previousTimerCancellable, nextTimerCancellable)) break block3;
                }
                break;
            }
        }

        private void offloadTimeout(Throwable cause) {
            if (this.parent.executor() == ((TimeoutPublisher)this.parent).timeoutExecutor) {
                this.processTimeout(cause);
            } else {
                this.signalOffloader.offloadSignal((Object)cause, this.contextProvider.wrapConsumer(this::processTimeout, this.contextProvider.contextMap()));
            }
        }

        private void processTimeout(Throwable cause) {
            PublisherSource.Subscription subscription = subscriptionUpdater.getAndSet(this, EmptySubscriptions.EMPTY_SUBSCRIPTION);
            if (subscription != null) {
                subscription.cancel();
            } else {
                this.target.onSubscribe(EmptySubscriptions.EMPTY_SUBSCRIPTION);
            }
            this.target.processOnError(cause);
        }

        private void stopTimer() {
            timerCancellableUpdater.getAndSet(this, LOCAL_IGNORE_CANCEL).cancel();
        }

        private static <X> void handleConstructorException(TimeoutSubscriber<X> s, SignalOffloader offloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider, Throwable cause) {
            s.timerCancellable = LOCAL_IGNORE_CANCEL;
            s.subscription = EmptySubscriptions.EMPTY_SUBSCRIPTION;
            PublishAndSubscribeOnPublishers.deliverOnSubscribeAndOnError(s.target, offloader, contextMap, contextProvider, cause);
        }
    }
}

