/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.internal.ThrowableUtils;
import io.servicetalk.utils.internal.PlatformDependent;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import javax.annotation.Nullable;

final class ClosableConcurrentStack<T> {
    private static final AtomicReferenceFieldUpdater<ClosableConcurrentStack, Object> topUpdater = AtomicReferenceFieldUpdater.newUpdater(ClosableConcurrentStack.class, Object.class, "top");
    @Nullable
    private volatile Object top;

    ClosableConcurrentStack() {
    }

    @Nullable
    boolean push(T item) {
        Object rawOldTop;
        Node<T> newTop = new Node<T>(item);
        do {
            if ((rawOldTop = this.top) != null && !Node.class.equals(rawOldTop.getClass())) {
                ((Consumer)rawOldTop).accept(item);
                return false;
            }
            newTop.next = (Node)rawOldTop;
        } while (!topUpdater.compareAndSet(this, rawOldTop, newTop));
        return true;
    }

    boolean relaxedRemove(T item) {
        Object rawCurrTop = this.top;
        if (item == null || rawCurrTop == null || !Node.class.equals(rawCurrTop.getClass())) {
            return false;
        }
        Node curr = (Node)rawCurrTop;
        Node prev = null;
        do {
            if (item.equals(curr.item)) {
                curr.item = null;
                if (prev != null) {
                    prev.next = curr.next;
                } else if (!topUpdater.compareAndSet(this, curr, curr.next)) {
                    this.removeNode(curr);
                }
                return true;
            }
            prev = curr;
        } while ((curr = curr.next) != null);
        return false;
    }

    private void removeNode(Node<T> nodeToRemove) {
        Object rawCurrTop;
        while ((rawCurrTop = this.top) != null && Node.class.equals(rawCurrTop.getClass())) {
            boolean failedTopRemoval = false;
            Node curr = (Node)rawCurrTop;
            Node prev = null;
            do {
                if (curr == nodeToRemove) {
                    if (prev == null) {
                        failedTopRemoval = !topUpdater.compareAndSet(this, curr, curr.next);
                        break;
                    }
                    prev.next = curr.next;
                    return;
                }
                prev = curr;
            } while ((curr = curr.next) != null);
            if (failedTopRemoval) continue;
            break;
        }
    }

    void close(Consumer<T> closer) {
        Object rawOldTop;
        block5: {
            Objects.requireNonNull(closer);
            while ((rawOldTop = this.top) == null || Node.class.equals(rawOldTop.getClass())) {
                if (!topUpdater.compareAndSet(this, rawOldTop, closer)) continue;
                break block5;
            }
            return;
        }
        Node oldTop = (Node)rawOldTop;
        Throwable delayedCause = null;
        while (oldTop != null) {
            Object item = oldTop.item;
            oldTop = oldTop.next;
            if (item == null) continue;
            try {
                closer.accept(item);
            }
            catch (Throwable cause) {
                delayedCause = ThrowableUtils.catchUnexpected(delayedCause, (Throwable)cause);
            }
        }
        if (delayedCause != null) {
            PlatformDependent.throwException(delayedCause);
        }
    }

    private static final class Node<T> {
        @Nullable
        T item;
        @Nullable
        Node<T> next;

        Node(T item) {
            this.item = Objects.requireNonNull(item);
        }
    }
}

