/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.context.api.ContextMapHolder;
import java.util.Objects;

final class ContextPreservingCancellable
implements Cancellable {
    private final ContextMap saved;
    private final Cancellable delegate;

    private ContextPreservingCancellable(Cancellable delegate, ContextMap current) {
        this.saved = Objects.requireNonNull(current);
        this.delegate = Objects.requireNonNull(delegate);
    }

    static Cancellable wrap(Cancellable delegate, ContextMap current) {
        return delegate instanceof ContextPreservingCancellable && ((ContextPreservingCancellable)delegate).saved == current ? delegate : new ContextPreservingCancellable(delegate, current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ContextMapHolder) {
            ContextMapHolder asyncContextMapHolder = (ContextMapHolder)currentThread;
            ContextMap prev = asyncContextMapHolder.context();
            try {
                asyncContextMapHolder.context(this.saved);
                this.delegate.cancel();
            }
            finally {
                asyncContextMapHolder.context(prev);
            }
        } else {
            this.slowPath();
        }
    }

    private void slowPath() {
        ContextMap prev = AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.get();
        try {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(this.saved);
            this.delegate.cancel();
        }
        finally {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(prev);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.delegate + ')';
    }
}

