/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.ContextPreservingBiConsumer;
import io.servicetalk.concurrent.api.ContextPreservingBiFunction;
import io.servicetalk.concurrent.api.ContextPreservingCallable;
import io.servicetalk.concurrent.api.ContextPreservingCancellableCompletableSubscriber;
import io.servicetalk.concurrent.api.ContextPreservingCancellableSingleSubscriber;
import io.servicetalk.concurrent.api.ContextPreservingCompletableFuture;
import io.servicetalk.concurrent.api.ContextPreservingCompletableSubscriber;
import io.servicetalk.concurrent.api.ContextPreservingCompletableSubscriberAndCancellable;
import io.servicetalk.concurrent.api.ContextPreservingConsumer;
import io.servicetalk.concurrent.api.ContextPreservingExecutor;
import io.servicetalk.concurrent.api.ContextPreservingExecutorService;
import io.servicetalk.concurrent.api.ContextPreservingFunction;
import io.servicetalk.concurrent.api.ContextPreservingRunnable;
import io.servicetalk.concurrent.api.ContextPreservingScheduledExecutorService;
import io.servicetalk.concurrent.api.ContextPreservingSingleSubscriber;
import io.servicetalk.concurrent.api.ContextPreservingSingleSubscriberAndCancellable;
import io.servicetalk.concurrent.api.ContextPreservingStExecutor;
import io.servicetalk.concurrent.api.ContextPreservingSubscriber;
import io.servicetalk.concurrent.api.ContextPreservingSubscriberAndSubscription;
import io.servicetalk.concurrent.api.ContextPreservingSubscriptionSubscriber;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.context.api.ContextMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

final class DefaultAsyncContextProvider
implements AsyncContextProvider {
    static final AsyncContextProvider INSTANCE = new DefaultAsyncContextProvider();
    private static final AsyncContextMapThreadLocal CONTEXT_LOCAL = new AsyncContextMapThreadLocal();

    private DefaultAsyncContextProvider() {
    }

    @Override
    @Nonnull
    public ContextMap context() {
        return CONTEXT_LOCAL.get();
    }

    @Override
    public CompletableSource.Subscriber wrapCancellable(CompletableSource.Subscriber subscriber, ContextMap context) {
        if (subscriber instanceof ContextPreservingCompletableSubscriber) {
            ContextPreservingCompletableSubscriber s = (ContextPreservingCompletableSubscriber)subscriber;
            if (s.saved == context) {
                return subscriber instanceof ContextPreservingCompletableSubscriberAndCancellable ? subscriber : new ContextPreservingCompletableSubscriberAndCancellable(s.subscriber, context);
            }
        } else if (subscriber instanceof ContextPreservingCancellableCompletableSubscriber && ((ContextPreservingCancellableCompletableSubscriber)subscriber).saved == context) {
            return subscriber;
        }
        return new ContextPreservingCancellableCompletableSubscriber(subscriber, context);
    }

    @Override
    public CompletableSource.Subscriber wrapCompletableSubscriber(CompletableSource.Subscriber subscriber, ContextMap context) {
        if (subscriber instanceof ContextPreservingCancellableCompletableSubscriber) {
            ContextPreservingCancellableCompletableSubscriber s = (ContextPreservingCancellableCompletableSubscriber)subscriber;
            if (s.saved == context) {
                return new ContextPreservingCompletableSubscriberAndCancellable(s.subscriber, context);
            }
        } else if (subscriber instanceof ContextPreservingCompletableSubscriber && ((ContextPreservingCompletableSubscriber)subscriber).saved == context) {
            return subscriber;
        }
        return new ContextPreservingCompletableSubscriber(subscriber, context);
    }

    @Override
    public CompletableSource.Subscriber wrapCompletableSubscriberAndCancellable(CompletableSource.Subscriber subscriber, ContextMap context) {
        if (subscriber instanceof ContextPreservingCompletableSubscriber) {
            ContextPreservingCompletableSubscriber s = (ContextPreservingCompletableSubscriber)subscriber;
            if (s.saved == context) {
                return subscriber instanceof ContextPreservingCompletableSubscriberAndCancellable ? subscriber : new ContextPreservingCompletableSubscriberAndCancellable(s.subscriber, context);
            }
        } else if (subscriber instanceof ContextPreservingCancellableCompletableSubscriber) {
            ContextPreservingCancellableCompletableSubscriber s = (ContextPreservingCancellableCompletableSubscriber)subscriber;
            if (s.saved == context) {
                return new ContextPreservingCompletableSubscriberAndCancellable(s.subscriber, context);
            }
        }
        return new ContextPreservingCompletableSubscriberAndCancellable(subscriber, context);
    }

    @Override
    public <T> SingleSource.Subscriber<T> wrapCancellable(SingleSource.Subscriber<T> subscriber, ContextMap context) {
        if (subscriber instanceof ContextPreservingSingleSubscriber) {
            ContextPreservingSingleSubscriber s = subscriber;
            if (s.saved == context) {
                return subscriber instanceof ContextPreservingSingleSubscriberAndCancellable ? subscriber : new ContextPreservingSingleSubscriberAndCancellable(s.subscriber, context);
            }
        } else if (subscriber instanceof ContextPreservingCancellableSingleSubscriber && ((ContextPreservingCancellableSingleSubscriber)((Object)subscriber)).saved == context) {
            return subscriber;
        }
        return new ContextPreservingCancellableSingleSubscriber<T>(subscriber, context);
    }

    @Override
    public <T> SingleSource.Subscriber<T> wrapSingleSubscriber(SingleSource.Subscriber<T> subscriber, ContextMap context) {
        if (subscriber instanceof ContextPreservingCancellableSingleSubscriber) {
            ContextPreservingCancellableSingleSubscriber s = (ContextPreservingCancellableSingleSubscriber)subscriber;
            if (s.saved == context) {
                return new ContextPreservingSingleSubscriberAndCancellable(s.subscriber, context);
            }
        } else if (subscriber instanceof ContextPreservingSingleSubscriber && ((ContextPreservingSingleSubscriber)subscriber).saved == context) {
            return subscriber;
        }
        return new ContextPreservingSingleSubscriber<T>(subscriber, context);
    }

    @Override
    public <T> SingleSource.Subscriber<T> wrapSingleSubscriberAndCancellable(SingleSource.Subscriber<T> subscriber, ContextMap context) {
        if (subscriber instanceof ContextPreservingSingleSubscriber) {
            ContextPreservingSingleSubscriber s = subscriber;
            if (s.saved == context) {
                return subscriber instanceof ContextPreservingSingleSubscriberAndCancellable ? subscriber : new ContextPreservingSingleSubscriberAndCancellable(s.subscriber, context);
            }
        } else if (subscriber instanceof ContextPreservingCancellableSingleSubscriber) {
            ContextPreservingCancellableSingleSubscriber s = (ContextPreservingCancellableSingleSubscriber)((Object)subscriber);
            if (s.saved == context) {
                return new ContextPreservingSingleSubscriberAndCancellable(s.subscriber, context);
            }
        }
        return new ContextPreservingSingleSubscriberAndCancellable<T>(subscriber, context);
    }

    @Override
    public <T> PublisherSource.Subscriber<T> wrapSubscription(PublisherSource.Subscriber<T> subscriber, ContextMap context) {
        if (subscriber instanceof ContextPreservingSubscriber) {
            ContextPreservingSubscriber s = subscriber;
            if (s.saved == context) {
                return subscriber instanceof ContextPreservingSubscriberAndSubscription ? subscriber : new ContextPreservingSubscriberAndSubscription(s.subscriber, context);
            }
        } else if (subscriber instanceof ContextPreservingSubscriptionSubscriber && ((ContextPreservingSubscriptionSubscriber)((Object)subscriber)).saved == context) {
            return subscriber;
        }
        return new ContextPreservingSubscriptionSubscriber<T>(subscriber, context);
    }

    @Override
    public <T> PublisherSource.Subscriber<T> wrapPublisherSubscriber(PublisherSource.Subscriber<T> subscriber, ContextMap context) {
        if (subscriber instanceof ContextPreservingSubscriptionSubscriber) {
            ContextPreservingSubscriptionSubscriber s = (ContextPreservingSubscriptionSubscriber)subscriber;
            if (s.saved == context) {
                return new ContextPreservingSubscriberAndSubscription(s.subscriber, context);
            }
        } else if (subscriber instanceof ContextPreservingSubscriber && ((ContextPreservingSubscriber)subscriber).saved == context) {
            return subscriber;
        }
        return new ContextPreservingSubscriber<T>(subscriber, context);
    }

    @Override
    public <T> PublisherSource.Subscriber<T> wrapPublisherSubscriberAndSubscription(PublisherSource.Subscriber<T> subscriber, ContextMap context) {
        if (subscriber instanceof ContextPreservingSubscriber) {
            ContextPreservingSubscriber s = subscriber;
            if (s.saved == context) {
                return subscriber instanceof ContextPreservingSubscriberAndSubscription ? subscriber : new ContextPreservingSubscriberAndSubscription(s.subscriber, context);
            }
        } else if (subscriber instanceof ContextPreservingSubscriptionSubscriber) {
            ContextPreservingSubscriptionSubscriber s = (ContextPreservingSubscriptionSubscriber)((Object)subscriber);
            if (s.saved == context) {
                return new ContextPreservingSubscriberAndSubscription(s.subscriber, context);
            }
        }
        return new ContextPreservingSubscriberAndSubscription<T>(subscriber, context);
    }

    @Override
    public java.util.concurrent.Executor wrapJdkExecutor(java.util.concurrent.Executor executor) {
        return ContextPreservingExecutor.of(executor);
    }

    @Override
    public ExecutorService wrapJdkExecutorService(ExecutorService executor) {
        return ContextPreservingExecutorService.of(executor);
    }

    @Override
    public Executor wrapExecutor(Executor executor) {
        return ContextPreservingStExecutor.of(executor);
    }

    @Override
    public ScheduledExecutorService wrapJdkScheduledExecutorService(ScheduledExecutorService executor) {
        return ContextPreservingScheduledExecutorService.of(executor);
    }

    @Override
    public <T> CompletableFuture<T> wrapCompletableFuture(CompletableFuture<T> future, ContextMap context) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(future, context);
    }

    @Override
    public Runnable wrapRunnable(Runnable runnable, ContextMap context) {
        return new ContextPreservingRunnable(runnable, context);
    }

    @Override
    public <V> Callable<V> wrapCallable(Callable<V> callable, ContextMap context) {
        return new ContextPreservingCallable<V>(callable, context);
    }

    @Override
    public <T> Consumer<T> wrapConsumer(Consumer<T> consumer, ContextMap context) {
        return new ContextPreservingConsumer<T>(consumer, context);
    }

    @Override
    public <T, U> Function<T, U> wrapFunction(Function<T, U> func, ContextMap context) {
        return new ContextPreservingFunction<T, U>(func, context);
    }

    @Override
    public <T, U> BiConsumer<T, U> wrapBiConsumer(BiConsumer<T, U> consumer, ContextMap context) {
        return new ContextPreservingBiConsumer<T, U>(consumer, context);
    }

    @Override
    public <T, U, V> BiFunction<T, U, V> wrapBiFunction(BiFunction<T, U, V> func, ContextMap context) {
        return new ContextPreservingBiFunction<T, U, V>(func, context);
    }
}

