/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.grpc.api.DefaultGrpcClientCallFactory;
import io.servicetalk.grpc.api.GrpcClientMetadata;
import io.servicetalk.grpc.api.GrpcExecutionContext;
import io.servicetalk.grpc.api.GrpcSerializationProvider;
import io.servicetalk.http.api.StreamingHttpClient;

public interface GrpcClientCallFactory
extends ListenableAsyncCloseable {
    public <Req, Resp> ClientCall<Req, Resp> newCall(GrpcSerializationProvider var1, Class<Req> var2, Class<Resp> var3);

    public <Req, Resp> StreamingClientCall<Req, Resp> newStreamingCall(GrpcSerializationProvider var1, Class<Req> var2, Class<Resp> var3);

    public <Req, Resp> RequestStreamingClientCall<Req, Resp> newRequestStreamingCall(GrpcSerializationProvider var1, Class<Req> var2, Class<Resp> var3);

    public <Req, Resp> ResponseStreamingClientCall<Req, Resp> newResponseStreamingCall(GrpcSerializationProvider var1, Class<Req> var2, Class<Resp> var3);

    public <Req, Resp> BlockingClientCall<Req, Resp> newBlockingCall(GrpcSerializationProvider var1, Class<Req> var2, Class<Resp> var3);

    public <Req, Resp> BlockingStreamingClientCall<Req, Resp> newBlockingStreamingCall(GrpcSerializationProvider var1, Class<Req> var2, Class<Resp> var3);

    public <Req, Resp> BlockingRequestStreamingClientCall<Req, Resp> newBlockingRequestStreamingCall(GrpcSerializationProvider var1, Class<Req> var2, Class<Resp> var3);

    public <Req, Resp> BlockingResponseStreamingClientCall<Req, Resp> newBlockingResponseStreamingCall(GrpcSerializationProvider var1, Class<Req> var2, Class<Resp> var3);

    public GrpcExecutionContext executionContext();

    public static GrpcClientCallFactory from(StreamingHttpClient httpClient) {
        return new DefaultGrpcClientCallFactory(httpClient);
    }

    public static interface BlockingResponseStreamingClientCall<Req, Resp> {
        public BlockingIterable<Resp> request(GrpcClientMetadata var1, Req var2) throws Exception;
    }

    public static interface BlockingRequestStreamingClientCall<Req, Resp> {
        public Resp request(GrpcClientMetadata var1, Iterable<Req> var2) throws Exception;
    }

    public static interface BlockingStreamingClientCall<Req, Resp> {
        public BlockingIterable<Resp> request(GrpcClientMetadata var1, Iterable<Req> var2) throws Exception;
    }

    public static interface BlockingClientCall<Req, Resp> {
        public Resp request(GrpcClientMetadata var1, Req var2) throws Exception;
    }

    public static interface ResponseStreamingClientCall<Req, Resp> {
        public Publisher<Resp> request(GrpcClientMetadata var1, Req var2);
    }

    public static interface RequestStreamingClientCall<Req, Resp> {
        public Single<Resp> request(GrpcClientMetadata var1, Publisher<Req> var2);
    }

    public static interface StreamingClientCall<Req, Resp> {
        public Publisher<Resp> request(GrpcClientMetadata var1, Publisher<Req> var2);
    }

    public static interface ClientCall<Req, Resp> {
        public Single<Resp> request(GrpcClientMetadata var1, Req var2);
    }
}

