/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.encoding.api.ContentCodings;
import io.servicetalk.grpc.api.BlockingGrpcClient;
import io.servicetalk.grpc.api.FilterableGrpcClient;
import io.servicetalk.grpc.api.GrpcClient;
import io.servicetalk.grpc.api.GrpcClientCallFactory;
import io.servicetalk.grpc.api.GrpcClientFilterFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class GrpcClientFactory<Client extends GrpcClient<BlockingClient>, BlockingClient extends BlockingGrpcClient<Client>, Filter extends FilterableClient, FilterableClient extends FilterableGrpcClient, FilterFactory extends GrpcClientFilterFactory<Filter, FilterableClient>> {
    @Nullable
    private FilterFactory filterFactory;
    private List<ContentCodec> supportedCodings = Collections.singletonList(ContentCodings.identity());

    final Client newClientForCallFactory(GrpcClientCallFactory clientCallFactory) {
        if (this.filterFactory == null) {
            return this.newClient((FilterableClient)clientCallFactory);
        }
        return this.newClient(this.newFilter(this.newClient((FilterableClient)clientCallFactory), this.filterFactory));
    }

    final BlockingClient newBlockingClientForCallFactory(GrpcClientCallFactory clientCallFactory) {
        if (this.filterFactory == null) {
            return this.newBlockingClient(clientCallFactory);
        }
        return this.newClient(this.newFilter(this.newBlockingClient(clientCallFactory).asClient(), this.filterFactory)).asBlockingClient();
    }

    public GrpcClientFactory<Client, BlockingClient, Filter, FilterableClient, FilterFactory> appendClientFilter(FilterFactory before) {
        this.filterFactory = this.filterFactory == null ? before : this.appendClientFilterFactory(this.filterFactory, (GrpcClientFilterFactory)Objects.requireNonNull(before));
        return this;
    }

    public GrpcClientFactory<Client, BlockingClient, Filter, FilterableClient, FilterFactory> supportedMessageCodings(List<ContentCodec> codings) {
        this.supportedCodings = Collections.unmodifiableList(new ArrayList<ContentCodec>(codings));
        return this;
    }

    protected List<ContentCodec> supportedMessageCodings() {
        return this.supportedCodings;
    }

    protected abstract FilterFactory appendClientFilterFactory(FilterFactory var1, FilterFactory var2);

    protected abstract Client newClient(GrpcClientCallFactory var1);

    protected abstract Filter newFilter(Client var1, FilterFactory var2);

    protected abstract Client newClient(FilterableClient var1);

    protected abstract BlockingClient newBlockingClient(GrpcClientCallFactory var1);
}

