/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.api;

import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.GracefulAutoCloseable;
import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.grpc.api.DefaultGrpcExecutionStrategy;
import io.servicetalk.grpc.api.GrpcExecutionStrategies;
import io.servicetalk.grpc.api.GrpcExecutionStrategy;
import io.servicetalk.grpc.api.GrpcPayloadWriter;
import io.servicetalk.grpc.api.GrpcRouter;
import io.servicetalk.grpc.api.GrpcSerializationProvider;
import io.servicetalk.grpc.api.GrpcService;
import io.servicetalk.grpc.api.GrpcServiceContext;
import io.servicetalk.grpc.api.GrpcServiceFactory;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.router.api.RouteExecutionStrategyFactory;
import io.servicetalk.router.utils.internal.DefaultRouteExecutionStrategyFactory;
import io.servicetalk.router.utils.internal.RouteExecutionStrategyUtils;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.ServerContext;
import io.servicetalk.utils.internal.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

public abstract class GrpcRoutes<Service extends GrpcService> {
    private static final GrpcExecutionStrategy NULL = new DefaultGrpcExecutionStrategy(HttpExecutionStrategies.noOffloadsStrategy());
    private final GrpcRouter.Builder routeBuilder;
    private final Set<String> errors;
    private final RouteExecutionStrategyFactory<GrpcExecutionStrategy> strategyFactory;

    protected GrpcRoutes() {
        this((RouteExecutionStrategyFactory<GrpcExecutionStrategy>)DefaultRouteExecutionStrategyFactory.defaultStrategyFactory());
    }

    protected GrpcRoutes(RouteExecutionStrategyFactory<GrpcExecutionStrategy> strategyFactory) {
        this.routeBuilder = new GrpcRouter.Builder();
        this.errors = new TreeSet<String>();
        this.strategyFactory = strategyFactory;
    }

    private GrpcRoutes(GrpcRouter.Builder routeBuilder, Set<String> errors) {
        this.routeBuilder = routeBuilder;
        this.errors = errors;
        this.strategyFactory = DefaultRouteExecutionStrategyFactory.defaultStrategyFactory();
    }

    final Single<ServerContext> bind(GrpcServiceFactory.ServerBinder binder, ExecutionContext executionContext) {
        if (!this.errors.isEmpty()) {
            throw new IllegalStateException("Invalid execution strategy configuration found:\n" + this.errors);
        }
        return this.routeBuilder.build().bind(binder, executionContext);
    }

    protected abstract void registerRoutes(Service var1);

    protected abstract Service newServiceFromRoutes(AllGrpcRoutes var1);

    AllGrpcRoutes drainToStreamingRoutes() {
        final GrpcRouter.RouteProviders routeProviders = this.routeBuilder.drainRoutes();
        return new AllGrpcRoutes(){

            @Override
            public <Req, Resp> StreamingRoute<Req, Resp> streamingRouteFor(String path) throws IllegalArgumentException {
                return routeProviders.routeProvider(path).asStreamingRoute();
            }

            @Override
            public <Req, Resp> Route<Req, Resp> routeFor(String path) throws IllegalArgumentException {
                return routeProviders.routeProvider(path).asRoute();
            }

            @Override
            public <Req, Resp> RequestStreamingRoute<Req, Resp> requestStreamingRouteFor(String path) throws IllegalArgumentException {
                return routeProviders.routeProvider(path).asRequestStreamingRoute();
            }

            @Override
            public <Req, Resp> ResponseStreamingRoute<Req, Resp> responseStreamingRouteFor(String path) throws IllegalArgumentException {
                return routeProviders.routeProvider(path).asResponseStreamingRoute();
            }

            public Completable closeAsync() {
                return routeProviders.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return routeProviders.closeAsyncGracefully();
            }
        };
    }

    static GrpcRoutes<?> merge(GrpcRoutes<?> ... allRoutes) {
        GrpcRouter.Builder[] builders = new GrpcRouter.Builder[allRoutes.length];
        TreeSet<String> errors = new TreeSet<String>();
        for (int i = 0; i < allRoutes.length; ++i) {
            builders[i] = allRoutes[i].routeBuilder;
            errors.addAll(allRoutes[i].errors);
        }
        return new GrpcRoutes<GrpcService>(GrpcRouter.Builder.merge(builders), errors){

            @Override
            protected void registerRoutes(GrpcService service) {
                throw new UnsupportedOperationException("Merged service factory can not register routes.");
            }

            @Override
            protected GrpcService newServiceFromRoutes(AllGrpcRoutes routes) {
                throw new UnsupportedOperationException("Merged service factory can not create new service.");
            }
        };
    }

    @Nullable
    private GrpcExecutionStrategy executionStrategy(String path, Method method, Class<?> clazz) {
        GrpcExecutionStrategy saved = this.routeBuilder.executionStrategyFor(path, NULL);
        if (saved != NULL) {
            return saved;
        }
        return (GrpcExecutionStrategy)RouteExecutionStrategyUtils.getAndValidateRouteExecutionStrategyAnnotationIfPresent((Method)method, clazz, this.strategyFactory, this.errors, (ExecutionStrategy)GrpcExecutionStrategies.noOffloadsStrategy());
    }

    protected final <Req, Resp> void addRoute(String path, Class<?> serviceClass, String methodName, Route<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
        Method method = ReflectionUtils.retrieveMethod(serviceClass, (String)methodName, (Class[])new Class[]{GrpcServiceContext.class, requestClass});
        this.routeBuilder.addRoute(path, this.executionStrategy(path, method, serviceClass), route, requestClass, responseClass, serializationProvider);
    }

    protected final <Req, Resp> void addRoute(String path, GrpcExecutionStrategy executionStrategy, Route<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
        this.routeBuilder.addRoute(path, executionStrategy, route, requestClass, responseClass, serializationProvider);
    }

    protected final <Req, Resp> void addStreamingRoute(String path, Class<?> serviceClass, String methodName, StreamingRoute<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
        Method method = ReflectionUtils.retrieveMethod(serviceClass, (String)methodName, (Class[])new Class[]{GrpcServiceContext.class, Publisher.class});
        this.routeBuilder.addStreamingRoute(path, this.executionStrategy(path, method, serviceClass), route, requestClass, responseClass, serializationProvider);
    }

    protected final <Req, Resp> void addStreamingRoute(String path, GrpcExecutionStrategy executionStrategy, StreamingRoute<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
        this.routeBuilder.addStreamingRoute(path, executionStrategy, route, requestClass, responseClass, serializationProvider);
    }

    protected final <Req, Resp> void addRequestStreamingRoute(String path, Class<?> serviceClass, String methodName, RequestStreamingRoute<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
        Method method = ReflectionUtils.retrieveMethod(serviceClass, (String)methodName, (Class[])new Class[]{GrpcServiceContext.class, Publisher.class});
        this.routeBuilder.addRequestStreamingRoute(path, this.executionStrategy(path, method, serviceClass), route, requestClass, responseClass, serializationProvider);
    }

    protected final <Req, Resp> void addRequestStreamingRoute(String path, GrpcExecutionStrategy executionStrategy, RequestStreamingRoute<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
        this.routeBuilder.addRequestStreamingRoute(path, executionStrategy, route, requestClass, responseClass, serializationProvider);
    }

    protected final <Req, Resp> void addResponseStreamingRoute(String path, Class<?> serviceClass, String methodName, ResponseStreamingRoute<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
        Method method = ReflectionUtils.retrieveMethod(serviceClass, (String)methodName, (Class[])new Class[]{GrpcServiceContext.class, requestClass});
        this.routeBuilder.addResponseStreamingRoute(path, this.executionStrategy(path, method, serviceClass), route, requestClass, responseClass, serializationProvider);
    }

    protected final <Req, Resp> void addResponseStreamingRoute(String path, GrpcExecutionStrategy executionStrategy, ResponseStreamingRoute<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
        this.routeBuilder.addResponseStreamingRoute(path, executionStrategy, route, requestClass, responseClass, serializationProvider);
    }

    protected final <Req, Resp> void addBlockingRoute(String path, Class<?> serviceClass, String methodName, BlockingRoute<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
        Method method = ReflectionUtils.retrieveMethod(serviceClass, (String)methodName, (Class[])new Class[]{GrpcServiceContext.class, requestClass});
        this.routeBuilder.addBlockingRoute(path, this.executionStrategy(path, method, serviceClass), route, requestClass, responseClass, serializationProvider);
    }

    protected final <Req, Resp> void addBlockingRoute(String path, GrpcExecutionStrategy executionStrategy, BlockingRoute<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
        this.routeBuilder.addBlockingRoute(path, executionStrategy, route, requestClass, responseClass, serializationProvider);
    }

    protected final <Req, Resp> void addBlockingStreamingRoute(String path, Class<?> serviceClass, String methodName, BlockingStreamingRoute<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
        Method method = ReflectionUtils.retrieveMethod(serviceClass, (String)methodName, (Class[])new Class[]{GrpcServiceContext.class, BlockingIterable.class, GrpcPayloadWriter.class});
        this.routeBuilder.addBlockingStreamingRoute(path, this.executionStrategy(path, method, serviceClass), route, requestClass, responseClass, serializationProvider);
    }

    protected final <Req, Resp> void addBlockingStreamingRoute(String path, GrpcExecutionStrategy executionStrategy, BlockingStreamingRoute<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
        this.routeBuilder.addBlockingStreamingRoute(path, executionStrategy, route, requestClass, responseClass, serializationProvider);
    }

    protected final <Req, Resp> void addBlockingRequestStreamingRoute(String path, Class<?> serviceClass, String methodName, BlockingRequestStreamingRoute<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
        Method method = ReflectionUtils.retrieveMethod(serviceClass, (String)methodName, (Class[])new Class[]{GrpcServiceContext.class, BlockingIterable.class});
        this.routeBuilder.addBlockingRequestStreamingRoute(path, this.executionStrategy(path, method, serviceClass), route, requestClass, responseClass, serializationProvider);
    }

    protected final <Req, Resp> void addBlockingRequestStreamingRoute(String path, GrpcExecutionStrategy executionStrategy, BlockingRequestStreamingRoute<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
        this.routeBuilder.addBlockingRequestStreamingRoute(path, executionStrategy, route, requestClass, responseClass, serializationProvider);
    }

    protected final <Req, Resp> void addBlockingResponseStreamingRoute(String path, Class<?> serviceClass, String methodName, BlockingResponseStreamingRoute<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
        Method method = ReflectionUtils.retrieveMethod(serviceClass, (String)methodName, (Class[])new Class[]{GrpcServiceContext.class, requestClass, GrpcPayloadWriter.class});
        this.routeBuilder.addBlockingResponseStreamingRoute(path, this.executionStrategy(path, method, serviceClass), route, requestClass, responseClass, serializationProvider);
    }

    protected final <Req, Resp> void addBlockingResponseStreamingRoute(String path, GrpcExecutionStrategy executionStrategy, BlockingResponseStreamingRoute<Req, Resp> route, Class<Req> requestClass, Class<Resp> responseClass, GrpcSerializationProvider serializationProvider) {
        this.routeBuilder.addBlockingResponseStreamingRoute(path, executionStrategy, route, requestClass, responseClass, serializationProvider);
    }

    protected static interface AllGrpcRoutes
    extends AsyncCloseable {
        public <Req, Resp> StreamingRoute<Req, Resp> streamingRouteFor(String var1) throws IllegalArgumentException;

        public <Req, Resp> Route<Req, Resp> routeFor(String var1) throws IllegalArgumentException;

        public <Req, Resp> RequestStreamingRoute<Req, Resp> requestStreamingRouteFor(String var1) throws IllegalArgumentException;

        public <Req, Resp> ResponseStreamingRoute<Req, Resp> responseStreamingRouteFor(String var1) throws IllegalArgumentException;
    }

    @FunctionalInterface
    protected static interface BlockingResponseStreamingRoute<Req, Resp>
    extends GracefulAutoCloseable {
        public void handle(GrpcServiceContext var1, Req var2, GrpcPayloadWriter<Resp> var3) throws Exception;

        default public void close() throws Exception {
        }

        public static <Req, Resp> BlockingResponseStreamingRoute<Req, Resp> wrap(final BlockingResponseStreamingRoute<Req, Resp> rawRoute, final GracefulAutoCloseable closeable) {
            return new BlockingResponseStreamingRoute<Req, Resp>(){

                @Override
                public void handle(GrpcServiceContext ctx, Req request, GrpcPayloadWriter<Resp> responseWriter) throws Exception {
                    rawRoute.handle(ctx, request, responseWriter);
                }

                @Override
                public void close() throws Exception {
                    closeable.close();
                }

                public void closeGracefully() throws Exception {
                    closeable.closeGracefully();
                }
            };
        }
    }

    @FunctionalInterface
    protected static interface BlockingRequestStreamingRoute<Req, Resp>
    extends GracefulAutoCloseable {
        public Resp handle(GrpcServiceContext var1, BlockingIterable<Req> var2) throws Exception;

        default public void close() throws Exception {
        }

        public static <Req, Resp> BlockingRequestStreamingRoute<Req, Resp> wrap(final BlockingRequestStreamingRoute<Req, Resp> rawRoute, final GracefulAutoCloseable closeable) {
            return new BlockingRequestStreamingRoute<Req, Resp>(){

                @Override
                public Resp handle(GrpcServiceContext ctx, BlockingIterable<Req> request) throws Exception {
                    return rawRoute.handle(ctx, request);
                }

                @Override
                public void close() throws Exception {
                    closeable.close();
                }

                public void closeGracefully() throws Exception {
                    closeable.closeGracefully();
                }
            };
        }
    }

    @FunctionalInterface
    protected static interface BlockingStreamingRoute<Req, Resp>
    extends GracefulAutoCloseable {
        public void handle(GrpcServiceContext var1, BlockingIterable<Req> var2, GrpcPayloadWriter<Resp> var3) throws Exception;

        default public void close() throws Exception {
        }

        public static <Req, Resp> BlockingStreamingRoute<Req, Resp> wrap(final BlockingStreamingRoute<Req, Resp> rawRoute, final GracefulAutoCloseable closeable) {
            return new BlockingStreamingRoute<Req, Resp>(){

                @Override
                public void handle(GrpcServiceContext ctx, BlockingIterable<Req> request, GrpcPayloadWriter<Resp> responseWriter) throws Exception {
                    rawRoute.handle(ctx, request, responseWriter);
                }

                @Override
                public void close() throws Exception {
                    closeable.close();
                }

                public void closeGracefully() throws Exception {
                    closeable.closeGracefully();
                }
            };
        }
    }

    @FunctionalInterface
    protected static interface BlockingRoute<Req, Resp>
    extends GracefulAutoCloseable {
        public Resp handle(GrpcServiceContext var1, Req var2) throws Exception;

        default public void close() throws Exception {
        }

        public static <Req, Resp> BlockingRoute<Req, Resp> wrap(final BlockingRoute<Req, Resp> rawRoute, final GracefulAutoCloseable closeable) {
            return new BlockingRoute<Req, Resp>(){

                @Override
                public Resp handle(GrpcServiceContext ctx, Req request) throws Exception {
                    return rawRoute.handle(ctx, request);
                }

                @Override
                public void close() throws Exception {
                    closeable.close();
                }

                public void closeGracefully() throws Exception {
                    closeable.closeGracefully();
                }
            };
        }
    }

    @FunctionalInterface
    protected static interface ResponseStreamingRoute<Req, Resp>
    extends AsyncCloseable {
        public Publisher<Resp> handle(GrpcServiceContext var1, Req var2);

        default public Completable closeAsync() {
            return Completable.completed();
        }

        public static <Req, Resp> ResponseStreamingRoute<Req, Resp> wrap(final ResponseStreamingRoute<Req, Resp> rawRoute, final AsyncCloseable closeable) {
            return new ResponseStreamingRoute<Req, Resp>(){

                @Override
                public Publisher<Resp> handle(GrpcServiceContext ctx, Req request) {
                    return rawRoute.handle(ctx, request);
                }

                @Override
                public Completable closeAsync() {
                    return closeable.closeAsync();
                }

                public Completable closeAsyncGracefully() {
                    return closeable.closeAsyncGracefully();
                }
            };
        }
    }

    @FunctionalInterface
    protected static interface RequestStreamingRoute<Req, Resp>
    extends AsyncCloseable {
        public Single<Resp> handle(GrpcServiceContext var1, Publisher<Req> var2);

        default public Completable closeAsync() {
            return Completable.completed();
        }

        public static <Req, Resp> RequestStreamingRoute<Req, Resp> wrap(final RequestStreamingRoute<Req, Resp> rawRoute, final AsyncCloseable closeable) {
            return new RequestStreamingRoute<Req, Resp>(){

                @Override
                public Single<Resp> handle(GrpcServiceContext ctx, Publisher<Req> request) {
                    return rawRoute.handle(ctx, request);
                }

                @Override
                public Completable closeAsync() {
                    return closeable.closeAsync();
                }

                public Completable closeAsyncGracefully() {
                    return closeable.closeAsyncGracefully();
                }
            };
        }
    }

    @FunctionalInterface
    protected static interface StreamingRoute<Req, Resp>
    extends AsyncCloseable {
        public Publisher<Resp> handle(GrpcServiceContext var1, Publisher<Req> var2);

        default public Completable closeAsync() {
            return Completable.completed();
        }

        public static <Req, Resp> StreamingRoute<Req, Resp> wrap(final StreamingRoute<Req, Resp> rawRoute, final AsyncCloseable closeable) {
            return new StreamingRoute<Req, Resp>(){

                @Override
                public Publisher<Resp> handle(GrpcServiceContext ctx, Publisher<Req> request) {
                    return rawRoute.handle(ctx, request);
                }

                @Override
                public Completable closeAsync() {
                    return closeable.closeAsync();
                }

                public Completable closeAsyncGracefully() {
                    return closeable.closeAsyncGracefully();
                }
            };
        }
    }

    @FunctionalInterface
    protected static interface Route<Req, Resp>
    extends AsyncCloseable {
        public Single<Resp> handle(GrpcServiceContext var1, Req var2);

        default public Completable closeAsync() {
            return Completable.completed();
        }

        public static <Req, Resp> Route<Req, Resp> wrap(final Route<Req, Resp> rawRoute, final AsyncCloseable closeable) {
            return new Route<Req, Resp>(){

                @Override
                public Single<Resp> handle(GrpcServiceContext ctx, Req request) {
                    return rawRoute.handle(ctx, request);
                }

                @Override
                public Completable closeAsync() {
                    return closeable.closeAsync();
                }

                public Completable closeAsyncGracefully() {
                    return closeable.closeAsyncGracefully();
                }
            };
        }
    }
}

