/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.protobuf;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UnsafeByteOperations;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.CompositeBuffer;
import io.servicetalk.buffer.netty.BufferAllocators;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.encoding.api.ContentCodings;
import io.servicetalk.serialization.api.SerializationException;
import io.servicetalk.serialization.api.SerializationProvider;
import io.servicetalk.serialization.api.StreamingDeserializer;
import io.servicetalk.serialization.api.StreamingSerializer;
import io.servicetalk.serialization.api.TypeHolder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;

final class ProtoBufSerializationProvider<T extends MessageLite>
implements SerializationProvider {
    private static final int LENGTH_PREFIXED_MESSAGE_HEADER_BYTES = 5;
    private static final byte FLAG_UNCOMPRESSED = 0;
    private static final byte FLAG_COMPRESSED = 1;
    private final Class<T> targetClass;
    private final ContentCodec codec;
    private final ProtoSerializer serializer;
    private final Parser<T> parser;

    ProtoBufSerializationProvider(Class<T> targetClass, ContentCodec codec, Parser<T> parser) {
        this.targetClass = targetClass;
        this.codec = codec;
        this.serializer = new ProtoSerializer(this.codec);
        this.parser = parser;
    }

    public <X> StreamingSerializer getSerializer(Class<X> classToSerialize) {
        if (this.targetClass != classToSerialize) {
            throw new SerializationException("Unknown class to serialize: " + classToSerialize.getName());
        }
        return this.serializer;
    }

    public <X> StreamingSerializer getSerializer(TypeHolder<X> typeToSerialize) {
        throw new UnsupportedOperationException("TypeHolder is not supported for protocol buffers serialization provider.");
    }

    public <X> StreamingDeserializer<X> getDeserializer(Class<X> classToDeSerialize) {
        if (this.targetClass != classToDeSerialize) {
            throw new SerializationException("Unknown class to deserialize: " + classToDeSerialize.getName());
        }
        Parser<T> parser = this.parser;
        return new ProtoDeserializer<T>(parser, this.codec);
    }

    public <X> StreamingDeserializer<X> getDeserializer(TypeHolder<X> typeToDeserialize) {
        throw new UnsupportedOperationException("TypeHolder is not supported for protocol buffers serialization provider.");
    }

    private static boolean isCompressed(Buffer buffer) throws SerializationException {
        byte compressionFlag = buffer.readByte();
        if (compressionFlag == 0) {
            return false;
        }
        if (compressionFlag == 1) {
            return true;
        }
        throw new SerializationException("compression flag must be 0 or 1 but was: " + compressionFlag);
    }

    private static final class ProtoSerializer
    implements StreamingSerializer {
        private final ContentCodec codec;
        private final boolean encode;

        ProtoSerializer(ContentCodec codec) {
            this.codec = codec;
            this.encode = codec != ContentCodings.identity();
        }

        public void serialize(Object toSerialize, Buffer destination) {
            if (!(toSerialize instanceof MessageLite)) {
                throw new SerializationException("Unknown type to serialize (expected MessageLite): " + toSerialize.getClass().getName());
            }
            if (this.encode) {
                this.serializeAndEncode((MessageLite)toSerialize, destination);
            } else {
                this.serializeOnly((MessageLite)toSerialize, destination);
            }
        }

        private void serializeOnly(MessageLite msg, Buffer destination) {
            int size = msg.getSerializedSize();
            destination.writeByte(0);
            destination.writeInt(size);
            destination.ensureWritable(size);
            this.serialize0(msg, destination);
        }

        private void serializeAndEncode(MessageLite msg, Buffer destination) {
            int size = msg.getSerializedSize();
            Buffer serialized = BufferAllocators.DEFAULT_ALLOCATOR.newBuffer(size);
            this.serialize0(msg, serialized);
            Buffer encoded = this.codec.encode(serialized, 0, serialized.readableBytes(), BufferAllocators.DEFAULT_ALLOCATOR);
            destination.writeByte(1);
            destination.writeInt(encoded.readableBytes());
            destination.ensureWritable(encoded.readableBytes());
            destination.writeBytes(encoded);
        }

        private void serialize0(MessageLite msg, Buffer destination) {
            int size = msg.getSerializedSize();
            int writerIdx = destination.writerIndex();
            int writableBytes = destination.writableBytes();
            CodedOutputStream out = destination.hasArray() ? CodedOutputStream.newInstance((byte[])destination.array(), (int)(destination.arrayOffset() + writerIdx), (int)writableBytes) : CodedOutputStream.newInstance((ByteBuffer)destination.toNioBuffer(writerIdx, writableBytes));
            try {
                msg.writeTo(out);
            }
            catch (IOException e) {
                throw new SerializationException((Throwable)e);
            }
            destination.writerIndex(writerIdx + size);
        }
    }

    private static final class ProtoDeserializer<T>
    implements StreamingDeserializer<T> {
        private final Parser<T> parser;
        private final CompositeBuffer accumulate;
        private final ContentCodec codec;
        private int lengthOfData = -1;
        private boolean compressed;

        ProtoDeserializer(Parser<T> parser, ContentCodec codec) {
            this.parser = parser;
            this.codec = codec;
            this.accumulate = BufferAllocators.DEFAULT_ALLOCATOR.newCompositeBuffer(Integer.MAX_VALUE);
        }

        public Iterable<T> deserialize(Buffer toDeserialize) {
            if (toDeserialize.readableBytes() <= 0) {
                return Collections.emptyList();
            }
            ArrayList<Object> parsedData = null;
            while (true) {
                Object t;
                toDeserialize = this.addToAccumulateIfAccumulating(toDeserialize);
                if (this.lengthOfData < 0) {
                    if (toDeserialize.readableBytes() < 5) {
                        return this.addToAccumulateIfRequiredAndReturn(toDeserialize, parsedData);
                    }
                    this.compressed = ProtoBufSerializationProvider.isCompressed(toDeserialize);
                    this.lengthOfData = toDeserialize.readInt();
                    if (this.lengthOfData >= 0) continue;
                    throw new SerializationException("Message-Length invalid: " + this.lengthOfData);
                }
                if (toDeserialize.readableBytes() < this.lengthOfData) {
                    return this.addToAccumulateIfRequiredAndReturn(toDeserialize, parsedData);
                }
                try {
                    CodedInputStream in;
                    Buffer buffer = toDeserialize;
                    int decodedLengthOfData = this.lengthOfData;
                    if (this.compressed) {
                        buffer = this.codec.decode(toDeserialize, 0, this.lengthOfData, BufferAllocators.DEFAULT_ALLOCATOR);
                        decodedLengthOfData = buffer.readableBytes();
                    }
                    if (buffer.nioBufferCount() == 1) {
                        ByteBuffer nioBuffer = buffer.toNioBuffer(buffer.readerIndex(), decodedLengthOfData);
                        in = CodedInputStream.newInstance((ByteBuffer)nioBuffer);
                    } else {
                        ByteBuffer[] buffers = buffer.toNioBuffers(buffer.readerIndex(), buffer.readableBytes());
                        in = buffers.length == 1 ? CodedInputStream.newInstance((ByteBuffer)buffers[0]) : ProtoDeserializer.newCodedInputStream(buffers, decodedLengthOfData);
                    }
                    t = this.parser.parseFrom(in);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new SerializationException((Throwable)e);
                }
                if (!this.compressed) {
                    toDeserialize.skipBytes(this.lengthOfData);
                }
                if (toDeserialize == this.accumulate) {
                    this.accumulate.discardSomeReadBytes();
                }
                int oldLengthOfData = this.lengthOfData;
                this.lengthOfData = -1;
                this.compressed = false;
                if (toDeserialize.readableBytes() < 5) {
                    if (toDeserialize != this.accumulate && toDeserialize.readableBytes() != 0) {
                        this.accumulate.addBuffer(toDeserialize, true);
                    }
                    if (parsedData == null) {
                        return Collections.singletonList(t);
                    }
                    parsedData.add(t);
                    return parsedData;
                }
                if (parsedData == null) {
                    parsedData = new ArrayList<Object>(1 + Math.max(1, toDeserialize.readableBytes() / (oldLengthOfData + 5)));
                }
                parsedData.add(t);
            }
        }

        private static CodedInputStream newCodedInputStream(ByteBuffer[] buffers, int lengthOfData) {
            CodedInputStream in = UnsafeByteOperations.unsafeWrap((ByteBuffer)ProtoDeserializer.mergeByteBuffers(buffers, lengthOfData)).newCodedInput();
            in.enableAliasing(true);
            return in;
        }

        private static ByteBuffer mergeByteBuffers(ByteBuffer[] buffers, int lengthOfData) {
            ByteBuffer merged = ByteBuffer.allocate(lengthOfData);
            for (ByteBuffer buf : buffers) {
                merged.put(buf);
            }
            merged.flip();
            return merged;
        }

        public boolean hasData() {
            return this.accumulate.readableBytes() > 0;
        }

        public void close() {
            if (this.hasData()) {
                throw new SerializationException("Deserializer disposed with left over data.");
            }
        }

        private Buffer addToAccumulateIfAccumulating(Buffer toDeserialize) {
            if (toDeserialize != this.accumulate && this.accumulate.readableBytes() > 0) {
                this.accumulate.addBuffer(toDeserialize, true);
                return this.accumulate;
            }
            return toDeserialize;
        }

        private Iterable<T> addToAccumulateIfRequiredAndReturn(Buffer toDeserialize, @Nullable Iterable<T> parsed) {
            if (this.accumulate != toDeserialize) {
                this.accumulate.addBuffer(toDeserialize, true);
            }
            return parsed == null ? Collections.emptyList() : parsed;
        }
    }
}

