/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.protobuf;

import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.encoding.api.ContentCodings;
import io.servicetalk.grpc.api.GrpcSerializationProvider;
import io.servicetalk.grpc.api.MessageEncodingException;
import io.servicetalk.grpc.protobuf.ProtoBufSerializationProvider;
import io.servicetalk.http.api.HttpDeserializer;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpPayloadWriter;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.serialization.api.DefaultSerializer;
import io.servicetalk.serialization.api.SerializationException;
import io.servicetalk.serialization.api.Serializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ProtoBufSerializationProviderBuilder {
    private static final CharSequence GRPC_MESSAGE_ENCODING_KEY = CharSequences.newAsciiString((String)"grpc-encoding");
    private static final CharSequence APPLICATION_GRPC_PROTO = CharSequences.newAsciiString((String)"application/grpc+proto");
    private final Map<Class<? extends MessageLite>, Parser<? extends MessageLite>> types = new HashMap<Class<? extends MessageLite>, Parser<? extends MessageLite>>();
    private final Map<Class, Map<ContentCodec, HttpSerializer>> serializers = new HashMap<Class, Map<ContentCodec, HttpSerializer>>();
    private final Map<Class, Map<ContentCodec, HttpDeserializer>> deserializers = new HashMap<Class, Map<ContentCodec, HttpDeserializer>>();
    private List<ContentCodec> supportedCodings = Collections.singletonList(ContentCodings.identity());

    public <T extends MessageLite> ProtoBufSerializationProviderBuilder supportedMessageCodings(List<ContentCodec> supportedCodings) {
        this.supportedCodings = new ArrayList<ContentCodec>(supportedCodings);
        if (!this.supportedCodings.contains(ContentCodings.identity())) {
            this.supportedCodings.add(ContentCodings.identity());
        }
        return this;
    }

    public <T extends MessageLite> ProtoBufSerializationProviderBuilder registerMessageType(Class<T> messageType, Parser<T> parser) {
        this.types.put(messageType, parser);
        return this;
    }

    private void build0() {
        for (Map.Entry<Class<? extends MessageLite>, Parser<? extends MessageLite>> entry : this.types.entrySet()) {
            final Class<? extends MessageLite> messageType = entry.getKey();
            Parser<? extends MessageLite> parser = entry.getValue();
            HashMap<ContentCodec, ProtoHttpSerializer<? extends MessageLite>> serializersForType = new HashMap<ContentCodec, ProtoHttpSerializer<? extends MessageLite>>();
            HashMap<ContentCodec, 1> deserializersForType = new HashMap<ContentCodec, 1>();
            for (ContentCodec codec : this.supportedCodings) {
                final DefaultSerializer serializer = new DefaultSerializer(new ProtoBufSerializationProvider<MessageLite>(messageType, codec, parser));
                ProtoHttpSerializer<? extends MessageLite> httpSerializer = new ProtoHttpSerializer<MessageLite>((Serializer)serializer, codec, messageType);
                serializersForType.put(codec, httpSerializer);
                deserializersForType.put(codec, new HttpDeserializer<MessageLite>(){

                    public MessageLite deserialize(HttpHeaders headers, Buffer payload) {
                        return (MessageLite)serializer.deserializeAggregatedSingle(payload, messageType);
                    }

                    public BlockingIterable<MessageLite> deserialize(HttpHeaders headers, BlockingIterable<Buffer> payload) {
                        return serializer.deserialize(payload, messageType);
                    }

                    public Publisher<MessageLite> deserialize(HttpHeaders headers, Publisher<Buffer> payload) {
                        return serializer.deserialize(payload, messageType);
                    }
                });
            }
            this.serializers.put(messageType, serializersForType);
            this.deserializers.put(messageType, deserializersForType);
        }
    }

    public GrpcSerializationProvider build() {
        this.build0();
        return new ProtoSerializationProvider(this.serializers, this.deserializers, this.supportedCodings);
    }

    private static final class ProtoHttpSerializer<T extends MessageLite>
    implements HttpSerializer<T> {
        private static final int METADATA_SIZE = 5;
        private final Serializer serializer;
        private final ContentCodec codec;
        private final Class<T> type;

        ProtoHttpSerializer(Serializer serializer, ContentCodec codec, Class<T> type) {
            this.serializer = serializer;
            this.codec = codec;
            this.type = type;
        }

        public Buffer serialize(HttpHeaders headers, T value, BufferAllocator allocator) {
            this.addContentHeaders(headers);
            return this.serializer.serialize(value, allocator, 5 + value.getSerializedSize());
        }

        public BlockingIterable<Buffer> serialize(HttpHeaders headers, BlockingIterable<T> value, BufferAllocator allocator) {
            this.addContentHeaders(headers);
            return this.serializer.serialize(value, allocator, this.type);
        }

        public Publisher<Buffer> serialize(HttpHeaders headers, Publisher<T> value, BufferAllocator allocator) {
            this.addContentHeaders(headers);
            return this.serializer.serialize(value, allocator, this.type);
        }

        public HttpPayloadWriter<T> serialize(HttpHeaders headers, final HttpPayloadWriter<Buffer> payloadWriter, final BufferAllocator allocator) {
            this.addContentHeaders(headers);
            return new HttpPayloadWriter<T>(){

                public HttpHeaders trailers() {
                    return payloadWriter.trailers();
                }

                public void write(T t) throws IOException {
                    payloadWriter.write((Object)serializer.serialize(t, allocator));
                }

                public void close() throws IOException {
                    payloadWriter.close();
                }

                public void close(Throwable cause) throws IOException {
                    payloadWriter.close(cause);
                }

                public void flush() throws IOException {
                    payloadWriter.flush();
                }
            };
        }

        private void addContentHeaders(HttpHeaders headers) {
            headers.set(HttpHeaderNames.CONTENT_TYPE, APPLICATION_GRPC_PROTO);
            if (this.codec != ContentCodings.identity()) {
                headers.set(GRPC_MESSAGE_ENCODING_KEY, this.codec.name());
            }
        }
    }

    private static class ProtoSerializationProvider
    implements GrpcSerializationProvider {
        private final Map<Class, Map<ContentCodec, HttpSerializer>> serializers;
        private final Map<Class, Map<ContentCodec, HttpDeserializer>> deserializers;
        private final List<ContentCodec> supportedCodings;

        ProtoSerializationProvider(Map<Class, Map<ContentCodec, HttpSerializer>> serializers, Map<Class, Map<ContentCodec, HttpDeserializer>> deserializers, List<ContentCodec> supportedCodings) {
            this.serializers = Collections.unmodifiableMap(serializers);
            this.deserializers = Collections.unmodifiableMap(deserializers);
            this.supportedCodings = Collections.unmodifiableList(supportedCodings);
        }

        public List<ContentCodec> supportedMessageCodings() {
            return this.supportedCodings;
        }

        public <T> HttpSerializer<T> serializerFor(ContentCodec codec, Class<T> type) {
            Map<ContentCodec, HttpSerializer> serializersForType = this.serializers.get(type);
            if (serializersForType == null) {
                throw new SerializationException("Unknown class to serialize: " + type.getName());
            }
            HttpSerializer httpSerializer = serializersForType.get(codec);
            if (httpSerializer == null) {
                throw new MessageEncodingException("Unknown encoding: " + codec.name());
            }
            return httpSerializer;
        }

        public <T> HttpDeserializer<T> deserializerFor(ContentCodec codec, Class<T> type) {
            Map<ContentCodec, HttpDeserializer> deserializersForType = this.deserializers.get(type);
            if (deserializersForType == null) {
                throw new SerializationException("Unknown class to deserialize: " + type.getName());
            }
            HttpDeserializer httpSerializer = deserializersForType.get(codec);
            if (httpSerializer == null) {
                throw new MessageEncodingException("Unknown encoding: " + codec.name());
            }
            return httpSerializer;
        }
    }
}

