/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.protoc;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.compiler.PluginProtos;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import io.servicetalk.grpc.protoc.GenerationContext;
import io.servicetalk.grpc.protoc.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;

final class FileDescriptor
implements GenerationContext {
    private static final String GENERATED_BY_COMMENT = "Generated by ServiceTalk proto compiler";
    private final DescriptorProtos.FileDescriptorProto protoFile;
    private final String sanitizedProtoFileName;
    @Nullable
    private final String protoPackageName;
    private final boolean deprecated;
    private final boolean multipleClassFiles;
    @Nullable
    private final String javaPackageName;
    @Nullable
    private final String outerClassName;
    @Nullable
    private final String typeNameSuffix;
    private final List<TypeSpec.Builder> serviceClassBuilders;
    @Nullable
    private Set<String> reservedJavaTypeName;

    FileDescriptor(DescriptorProtos.FileDescriptorProto protoFile, @Nullable String typeNameSuffix) {
        this.protoFile = protoFile;
        this.sanitizedProtoFileName = FileDescriptor.sanitizeFileName(protoFile.getName());
        this.protoPackageName = protoFile.hasPackage() ? protoFile.getPackage() : null;
        this.typeNameSuffix = typeNameSuffix;
        if (protoFile.hasOptions()) {
            DescriptorProtos.FileOptions fileOptions = protoFile.getOptions();
            this.deprecated = fileOptions.hasDeprecated() && fileOptions.getDeprecated();
            this.multipleClassFiles = fileOptions.hasJavaMultipleFiles() && fileOptions.getJavaMultipleFiles();
            this.javaPackageName = fileOptions.hasJavaPackage() ? fileOptions.getJavaPackage() : null;
            this.outerClassName = fileOptions.hasJavaOuterClassname() ? fileOptions.getJavaOuterClassname() : null;
        } else {
            this.deprecated = false;
            this.multipleClassFiles = false;
            this.javaPackageName = null;
            this.outerClassName = null;
        }
        this.serviceClassBuilders = new ArrayList<TypeSpec.Builder>(protoFile.getServiceCount());
    }

    String protoFileName() {
        return this.protoFile.getName();
    }

    List<DescriptorProtos.ServiceDescriptorProto> protoServices() {
        return this.protoFile.getServiceList();
    }

    Map<String, ClassName> messageTypesMap() {
        HashMap<String, ClassName> messageTypesMap = new HashMap<String, ClassName>(this.protoFile.getMessageTypeCount());
        this.addMessageTypes(this.protoFile.getMessageTypeList(), this.protoPackageName != null ? '.' + this.protoPackageName : null, this.multipleClassFiles ? this.javaPackageName() : this.javaPackageName() + '.' + this.outerJavaClassName(), messageTypesMap);
        return messageTypesMap;
    }

    private void addMessageTypes(List<DescriptorProtos.DescriptorProto> messageTypes, @Nullable String parentProtoScope, @Nullable String parentJavaScope, Map<String, ClassName> messageTypesMap) {
        messageTypes.forEach(t -> {
            String protoTypeName = (parentProtoScope != null ? parentProtoScope : "") + '.' + t.getName();
            String javaClassName = parentJavaScope + '.' + t.getName();
            messageTypesMap.put(protoTypeName, ClassName.bestGuess((String)javaClassName));
            this.addMessageTypes(t.getNestedTypeList(), protoTypeName, javaClassName, messageTypesMap);
        });
    }

    @Override
    public String deconflictJavaTypeName(String name) {
        String uniqueName;
        if (this.reservedJavaTypeName == null) {
            this.reservedJavaTypeName = new HashSet<String>();
            this.reservedJavaTypeName.add(this.outerJavaClassName());
        }
        if (this.reservedJavaTypeName.add(name)) {
            return name;
        }
        int i = 0;
        do {
            uniqueName = name + i;
            ++i;
        } while (!this.reservedJavaTypeName.add(uniqueName));
        return uniqueName;
    }

    @Override
    public TypeSpec.Builder newServiceClassBuilder(DescriptorProtos.ServiceDescriptorProto serviceProto) {
        String rawClassName = this.typeNameSuffix == null ? serviceProto.getName() : serviceProto.getName() + this.typeNameSuffix;
        String className = this.deconflictJavaTypeName(FileDescriptor.sanitizeClassName(rawClassName));
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addComment("no instances", new Object[0]).build());
        if (this.deprecated || serviceProto.hasOptions() && serviceProto.getOptions().hasDeprecated() && serviceProto.getOptions().getDeprecated()) {
            builder.addAnnotation(Deprecated.class);
        }
        this.serviceClassBuilders.add(builder);
        return builder;
    }

    @Override
    public String methodPath(DescriptorProtos.ServiceDescriptorProto serviceProto, DescriptorProtos.MethodDescriptorProto methodProto) {
        StringBuilder sb = new StringBuilder(128).append('/');
        if (StringUtils.isNotNullNorEmpty(this.protoPackageName)) {
            sb.append(this.protoPackageName).append('.');
        }
        sb.append(serviceProto.getName()).append('/').append(methodProto.getName());
        return sb.toString();
    }

    void writeTo(PluginProtos.CodeGeneratorResponse.Builder responseBuilder) {
        if (this.serviceClassBuilders.isEmpty()) {
            return;
        }
        if (!this.multipleClassFiles) {
            String fileName = FileDescriptor.calculateFileName(this.javaPackageName(), this.outerJavaClassName());
            FileDescriptor.insertSingleFileContent("// Generated by ServiceTalk proto compiler", fileName, responseBuilder);
            for (TypeSpec.Builder builder : this.serviceClassBuilders) {
                FileDescriptor.insertSingleFileContent(builder.addModifiers(new Modifier[]{Modifier.STATIC}).build().toString(), fileName, responseBuilder);
            }
            return;
        }
        String packageName = this.javaPackageName();
        for (TypeSpec.Builder builder : this.serviceClassBuilders) {
            TypeSpec serviceType = builder.build();
            PluginProtos.CodeGeneratorResponse.File.Builder fileBuilder = PluginProtos.CodeGeneratorResponse.File.newBuilder();
            fileBuilder.setName(FileDescriptor.calculateFileName(packageName, serviceType.name));
            JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)serviceType).addFileComment(GENERATED_BY_COMMENT, new Object[0]).build();
            fileBuilder.setContent(javaFile.toString());
            responseBuilder.addFile(fileBuilder.build());
        }
    }

    private static void insertSingleFileContent(String content, String fileName, PluginProtos.CodeGeneratorResponse.Builder responseBuilder) {
        PluginProtos.CodeGeneratorResponse.File.Builder fileBuilder = PluginProtos.CodeGeneratorResponse.File.newBuilder();
        fileBuilder.setName(fileName);
        fileBuilder.setInsertionPoint("outer_class_scope");
        fileBuilder.setContent(content + "\n");
        responseBuilder.addFile(fileBuilder.build());
    }

    private String outerJavaClassName() {
        return StringUtils.isNotNullNorEmpty(this.outerClassName) ? FileDescriptor.sanitizeClassName(this.outerClassName) : FileDescriptor.sanitizeClassName(this.sanitizedProtoFileName);
    }

    private String javaPackageName() {
        return StringUtils.isNotNullNorEmpty(this.javaPackageName) ? this.javaPackageName : (StringUtils.isNotNullNorEmpty(this.protoPackageName) ? this.protoPackageName : FileDescriptor.sanitizeClassName(this.sanitizedProtoFileName));
    }

    private static String sanitizeFileName(String v) {
        int i = v.lastIndexOf(47);
        int j = v.lastIndexOf(46);
        if (i != -1 && j != -1) {
            if (++i >= v.length()) {
                throw new IllegalArgumentException("Illegal file name: " + v);
            }
            return v.substring(i, j);
        }
        if (j != -1) {
            return v.substring(0, j);
        }
        return v;
    }

    private static String sanitizeClassName(String v) {
        return StringUtils.sanitizeIdentifier(v, false);
    }

    private static String calculateFileName(String packageName, String className) {
        return packageName.replace('.', '/') + '/' + className + ".java";
    }
}

