/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.BlockingStreamingHttpResponse;
import io.servicetalk.http.api.DefaultBlockingStreamingHttpResponse;
import io.servicetalk.http.api.DefaultHttpResponse;
import io.servicetalk.http.api.DefaultHttpResponseMetaData;
import io.servicetalk.http.api.DefaultPayloadInfo;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.PayloadInfo;
import io.servicetalk.http.api.StreamingHttpPayloadHolder;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.TrailersTransformer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

final class DefaultStreamingHttpResponse
extends DefaultHttpResponseMetaData
implements StreamingHttpResponse,
PayloadInfo {
    private final StreamingHttpPayloadHolder payloadHolder;

    DefaultStreamingHttpResponse(HttpResponseStatus status, HttpProtocolVersion version, HttpHeaders headers, BufferAllocator allocator, @Nullable Publisher<?> payloadBody, DefaultPayloadInfo payloadInfo, HttpHeadersFactory headersFactory) {
        super(status, version, headers);
        this.payloadHolder = new StreamingHttpPayloadHolder(headers, allocator, payloadBody, payloadInfo, headersFactory, version);
    }

    @Override
    public StreamingHttpResponse version(HttpProtocolVersion version) {
        super.version(version);
        return this;
    }

    @Override
    public StreamingHttpResponse status(HttpResponseStatus status) {
        super.status(status);
        return this;
    }

    @Override
    public StreamingHttpResponse encoding(ContentCodec encoding) {
        super.encoding(encoding);
        return this;
    }

    @Override
    public Publisher<Buffer> payloadBody() {
        return this.payloadHolder.payloadBody();
    }

    @Override
    @Deprecated
    public Publisher<Object> payloadBodyAndTrailers() {
        return this.payloadHolder.payloadBodyAndTrailers();
    }

    @Override
    public Publisher<Object> messageBody() {
        return this.payloadHolder.messageBody();
    }

    @Override
    public StreamingHttpResponse payloadBody(Publisher<Buffer> payloadBody) {
        this.payloadHolder.payloadBody(payloadBody);
        return this;
    }

    @Override
    public <T> StreamingHttpResponse payloadBody(Publisher<T> payloadBody, HttpSerializer<T> serializer) {
        this.payloadHolder.payloadBody(payloadBody, serializer);
        return this;
    }

    @Override
    public <T> StreamingHttpResponse transformPayloadBody(Function<Publisher<Buffer>, Publisher<T>> transformer, HttpSerializer<T> serializer) {
        this.payloadHolder.transformPayloadBody(transformer, serializer);
        return this;
    }

    @Override
    public StreamingHttpResponse transformPayloadBody(UnaryOperator<Publisher<Buffer>> transformer) {
        this.payloadHolder.transformPayloadBody(transformer);
        return this;
    }

    @Override
    @Deprecated
    public StreamingHttpResponse transformRawPayloadBody(UnaryOperator<Publisher<?>> transformer) {
        this.payloadHolder.transformRawPayloadBody(transformer);
        return this;
    }

    @Override
    public StreamingHttpResponse transformMessageBody(UnaryOperator<Publisher<?>> transformer) {
        this.payloadHolder.transformMessageBody(transformer);
        return this;
    }

    @Override
    public <T> StreamingHttpResponse transform(TrailersTransformer<T, Buffer> trailersTransformer) {
        this.payloadHolder.transform(trailersTransformer);
        return this;
    }

    @Override
    @Deprecated
    public <T> StreamingHttpResponse transformRaw(TrailersTransformer<T, Object> trailersTransformer) {
        this.payloadHolder.transformRaw(trailersTransformer);
        return this;
    }

    @Override
    public Single<HttpResponse> toResponse() {
        return this.payloadHolder.aggregate().map(pair -> {
            assert (pair.payload != null);
            return new DefaultHttpResponse(this, pair.payload, pair.trailers);
        });
    }

    @Override
    public BlockingStreamingHttpResponse toBlockingStreamingResponse() {
        return new DefaultBlockingStreamingHttpResponse(this);
    }

    @Override
    public boolean isSafeToAggregate() {
        return this.payloadHolder.isSafeToAggregate();
    }

    @Override
    public boolean mayHaveTrailers() {
        return this.payloadHolder.mayHaveTrailers();
    }

    @Override
    public boolean onlyEmitsBuffer() {
        return this.payloadHolder.onlyEmitsBuffer();
    }

    StreamingHttpPayloadHolder payloadHolder() {
        return this.payloadHolder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultStreamingHttpResponse that = (DefaultStreamingHttpResponse)o;
        return this.payloadHolder.equals(that.payloadHolder);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.payloadHolder.hashCode();
        return result;
    }
}

