/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.Uri;
import io.servicetalk.http.api.UriComponentType;
import io.servicetalk.http.api.UriUtils;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.Nullable;

final class Uri3986
implements Uri {
    private static final String NULL_COMPONENT = new String("");
    private final String uri;
    @Nullable
    private final String scheme;
    @Nullable
    private final String userInfo;
    @Nullable
    private final String host;
    private final int port;
    private final String path;
    @Nullable
    private String query;
    @Nullable
    private String fragment;

    Uri3986(String uri) {
        int i = 0;
        int begin = 0;
        String parsedScheme = null;
        String parsedUserInfo = null;
        String parsedHost = null;
        int parsedPort = -1;
        String parsedPath = null;
        boolean eligibleToParseScheme = true;
        block0: while (i < uri.length()) {
            char c = uri.charAt(i);
            if (c == '/') {
                if (begin == i && parsedHost == null && uri.length() - 1 > i && uri.charAt(i + 1) == '/') {
                    int authorityBegin = begin = (i += 2);
                    int parsingIPv6 = 0;
                    boolean foundColonForPort = false;
                    while (i < uri.length()) {
                        char c2 = uri.charAt(i);
                        if (c2 == '@') {
                            if (parsedUserInfo != null) {
                                throw new IllegalArgumentException("duplicate userinfo");
                            }
                            parsedUserInfo = uri.substring(authorityBegin, i);
                            parsedHost = null;
                            begin = ++i;
                            continue;
                        }
                        if (c2 == '[') {
                            if (parsingIPv6 != 0 || parsedHost != null) {
                                throw new IllegalArgumentException("unexpected [");
                            }
                            parsingIPv6 = 1;
                            begin = i++;
                            continue;
                        }
                        if (c2 == ']') {
                            if (parsingIPv6 == 0) {
                                throw new IllegalArgumentException("unexpected ]");
                            }
                            if (i - 1 <= begin) {
                                throw new IllegalArgumentException("empty ip literal");
                            }
                            parsedHost = uri.substring(begin, i + 1);
                            foundColonForPort = false;
                            parsingIPv6 = 2;
                            begin = ++i;
                            continue;
                        }
                        if (c2 == ':') {
                            if (parsingIPv6 == 0) {
                                if (parsedHost != null) {
                                    throw new IllegalArgumentException("duplicate/invalid host");
                                }
                                parsedHost = uri.substring(begin, i);
                            } else if (parsingIPv6 == 2 && begin != i) {
                                throw new IllegalArgumentException("Port must be immediately after IPv6address");
                            }
                            ++i;
                            if (parsingIPv6 == 1) continue;
                            begin = i;
                            foundColonForPort = true;
                            continue;
                        }
                        if (c2 == '?' || c2 == '#' || c2 == '/') {
                            if (parsedHost == null) {
                                if (parsingIPv6 == 1) {
                                    throw new IllegalArgumentException("missing closing ] for IP-literal");
                                }
                                parsedHost = uri.substring(begin, i);
                            } else if (foundColonForPort) {
                                parsedPort = UriUtils.parsePort(uri, begin, i);
                            }
                            if (c2 == '/') {
                                begin = i++;
                                continue block0;
                            }
                            parsedPath = "";
                            begin = ++i;
                            break block0;
                        }
                        ++i;
                    }
                    if (i != uri.length()) continue;
                    if (parsedHost == null) {
                        if (parsingIPv6 == 1) {
                            throw new IllegalArgumentException("missing closing ] for IP-literal");
                        }
                        parsedHost = uri.substring(begin);
                    } else if (foundColonForPort) {
                        parsedPort = UriUtils.parsePort(uri, begin, i);
                    }
                    begin = i;
                    continue;
                }
                eligibleToParseScheme = false;
                ++i;
                continue;
            }
            if (c == ':' && begin == 0 && parsedScheme == null && eligibleToParseScheme) {
                if (i == 0) {
                    throw new IllegalArgumentException("empty scheme");
                }
                parsedScheme = uri.substring(0, i);
                begin = ++i;
                continue;
            }
            if (c == '?' || c == '#') {
                parsedPath = uri.substring(begin, i);
                break;
            }
            ++i;
        }
        if (i == uri.length()) {
            parsedPath = uri.substring(begin);
        }
        assert (parsedPath != null);
        this.scheme = parsedScheme;
        this.userInfo = parsedUserInfo;
        this.host = parsedHost;
        this.port = parsedPort;
        this.path = parsedPath;
        this.uri = uri;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    @Nullable
    public String scheme() {
        return this.scheme;
    }

    @Override
    @Nullable
    public String authority() {
        StringBuilder sb;
        if (this.host == null) {
            return null;
        }
        if (this.userInfo == null) {
            sb = new StringBuilder(this.host.length() + 6);
        } else {
            sb = new StringBuilder(this.host.length() + this.userInfo.length() + 7);
            sb.append(this.userInfo).append('@');
        }
        sb.append(this.host);
        if (this.port >= 0) {
            sb.append(':').append(this.port);
        }
        return sb.toString();
    }

    @Override
    @Nullable
    public String userInfo() {
        return this.userInfo;
    }

    @Override
    @Nullable
    public String host() {
        return this.host;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String path(Charset charset) {
        return UriUtils.decodeComponent(this.path, charset);
    }

    @Override
    public String query() {
        if (this.query != null) {
            return Uri3986.unwrapNullableComponent(this.query);
        }
        int pathEndIndex = this.pathEndIndex();
        if (pathEndIndex >= this.uri.length() || this.uri.charAt(pathEndIndex) != '?') {
            this.query = NULL_COMPONENT;
            return null;
        }
        int fragmentStart = this.uri.indexOf(35, pathEndIndex + 1);
        this.query = fragmentStart < 0 ? this.uri.substring(pathEndIndex + 1) : this.uri.substring(pathEndIndex + 1, fragmentStart);
        return this.query;
    }

    @Override
    @Nullable
    public String query(Charset charset) {
        String query = this.query();
        return query == null ? null : UriUtils.decodeComponent(query, charset);
    }

    @Override
    public String fragment() {
        if (this.fragment != null) {
            return Uri3986.unwrapNullableComponent(this.fragment);
        }
        int pathEndIndex = this.pathEndIndex();
        if (pathEndIndex >= this.uri.length()) {
            this.fragment = NULL_COMPONENT;
            return null;
        }
        int fragmentStart = this.uri.indexOf(35, pathEndIndex);
        if (fragmentStart < 0) {
            this.fragment = NULL_COMPONENT;
            return null;
        }
        this.fragment = this.uri.substring(fragmentStart + 1);
        return this.fragment;
    }

    @Nullable
    private static String unwrapNullableComponent(String component) {
        return component == NULL_COMPONENT ? null : component;
    }

    private int pathEndIndex() {
        int i = 0;
        if (this.scheme != null) {
            i = this.scheme.length() + 1;
        }
        if (this.host != null) {
            i += this.host.length() + 2;
            if (this.userInfo != null) {
                i += this.userInfo.length() + 1;
            }
            if (this.port >= 0) {
                i += Uri3986.numberOfDigits(this.port) + 1;
            }
        }
        return i += this.path.length();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Uri3986)) {
            return false;
        }
        Uri3986 rhs = (Uri3986)o;
        return this.port == rhs.port && Objects.equals(this.host, rhs.host);
    }

    public int hashCode() {
        return 31 * (31 + this.port + Objects.hashCode(this.host));
    }

    public String toString() {
        return this.uri;
    }

    static String encode(String requestTarget, Charset charset, boolean preservePctEncoding) {
        String fragment;
        String path;
        Uri3986 uri = new Uri3986(requestTarget);
        StringBuilder sb = new StringBuilder(uri.uri.length() + 16);
        if (uri.scheme != null) {
            sb.append(uri.scheme).append(':');
        }
        if (uri.host != null) {
            sb.append("//");
            if (uri.userInfo != null) {
                sb.append(UriUtils.encodeComponent(UriComponentType.USER_INFO, uri.userInfo, charset, preservePctEncoding)).append('@');
            }
            if (!uri.host.isEmpty()) {
                sb.append(uri.host.charAt(0) != '[' ? UriUtils.encodeComponent(UriComponentType.HOST_NON_IP, uri.host, charset, preservePctEncoding) : uri.host);
            }
            if (uri.port >= 0) {
                sb.append(':').append(uri.port);
            }
        }
        if (!(path = uri.path()).isEmpty() && path.charAt(0) != '/') {
            sb.append('/');
        }
        sb.append(UriUtils.encodeComponent(UriComponentType.PATH, path, charset, preservePctEncoding));
        String query = uri.query();
        if (query != null) {
            sb.append('?').append(UriUtils.encodeComponent(UriComponentType.QUERY, query, charset, preservePctEncoding));
        }
        if ((fragment = uri.fragment()) != null) {
            sb.append('#').append(UriUtils.encodeComponent(UriComponentType.FRAGMENT, fragment, charset, preservePctEncoding));
        }
        return sb.toString();
    }

    static String decode(String requestTarget, Charset charset) {
        String fragment;
        String path;
        Uri3986 uri = new Uri3986(requestTarget);
        StringBuilder sb = new StringBuilder(uri.uri.length());
        if (uri.scheme != null) {
            sb.append(uri.scheme).append(':');
        }
        if (uri.host != null) {
            sb.append("//");
            if (uri.userInfo != null) {
                sb.append(UriUtils.decodeComponent(uri.userInfo, charset)).append('@');
            }
            if (!uri.host.isEmpty()) {
                sb.append(uri.host.charAt(0) != '[' ? UriUtils.decodeComponent(uri.host, charset) : uri.host);
            }
            if (uri.port >= 0) {
                sb.append(':').append(uri.port);
            }
        }
        if (!(path = uri.path()).isEmpty() && path.charAt(0) != '/') {
            sb.append('/');
        }
        sb.append(UriUtils.decodeComponent(path, charset));
        String query = uri.query();
        if (query != null) {
            sb.append('?').append(UriUtils.decodeComponent(query, charset));
        }
        if ((fragment = uri.fragment()) != null) {
            sb.append('#').append(UriUtils.decodeComponent(fragment, charset));
        }
        return sb.toString();
    }

    private static int numberOfDigits(int port) {
        if (port < 10000) {
            if (port < 1000) {
                if (port < 100) {
                    return port < 10 ? 1 : 2;
                }
                return 3;
            }
            return 4;
        }
        if (port <= 65535) {
            return 5;
        }
        throw new IllegalArgumentException("port out of bounds: " + port);
    }
}

