/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.util.ReferenceCountUtil;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.netty.BufferUtils;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.netty.H2ToStH1Utils;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.Http2Exception;
import io.servicetalk.http.netty.HttpObjectEncoder;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.netty.internal.ChannelCloseUtils;
import io.servicetalk.transport.netty.internal.CloseHandler;
import javax.annotation.Nullable;

abstract class AbstractH2DuplexHandler
extends ChannelDuplexHandler {
    final BufferAllocator allocator;
    final HttpHeadersFactory headersFactory;
    final CloseHandler closeHandler;
    private final ConnectionObserver.StreamObserver observer;
    private long contentLength = Long.MIN_VALUE;
    private long seenContentLength;

    AbstractH2DuplexHandler(BufferAllocator allocator, HttpHeadersFactory headersFactory, CloseHandler closeHandler, ConnectionObserver.StreamObserver observer) {
        this.allocator = allocator;
        this.headersFactory = headersFactory;
        this.closeHandler = closeHandler;
        this.observer = observer;
    }

    public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof Http2ResetFrame) {
            ctx.fireExceptionCaught((Throwable)Http2Exception.newStreamResetException((Http2ResetFrame)evt));
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    static void writeBuffer(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        ctx.write((Object)new DefaultHttp2DataFrame(HttpObjectEncoder.encodeAndRetain((Buffer)msg), false), promise);
    }

    final void writeTrailers(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        this.closeHandler.protocolPayloadEndOutbound(ctx, promise);
        Http2Headers h2Headers = H2ToStH1Utils.h1HeadersToH2Headers((HttpHeaders)msg);
        if (h2Headers.isEmpty()) {
            ctx.write((Object)new DefaultHttp2DataFrame(Unpooled.EMPTY_BUFFER, true), promise);
        } else {
            ctx.write((Object)new DefaultHttp2HeadersFrame(h2Headers, true), promise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void readDataFrame(ChannelHandlerContext ctx, Object msg) {
        Object toRelease = msg;
        try {
            Http2DataFrame dataFrame = (Http2DataFrame)msg;
            int readableBytes = dataFrame.content().readableBytes();
            if (readableBytes > 0) {
                this.updateSeenContentLength(readableBytes);
                Buffer data = this.allocator.newBuffer(readableBytes);
                ByteBuf nettyData = BufferUtils.toByteBuf((Buffer)data);
                nettyData.writeBytes(dataFrame.content());
                toRelease = AbstractH2DuplexHandler.release(dataFrame);
                ctx.fireChannelRead((Object)data);
            } else {
                toRelease = AbstractH2DuplexHandler.release(dataFrame);
            }
            if (dataFrame.isEndStream()) {
                this.validateContentLengthMatch();
                ctx.fireChannelRead((Object)this.headersFactory.newEmptyTrailers());
                this.closeHandler.protocolPayloadEndInbound(ctx);
            }
        }
        finally {
            if (toRelease != null) {
                ReferenceCountUtil.release((Object)toRelease);
            }
        }
    }

    @Nullable
    private static Http2DataFrame release(Http2DataFrame dataFrame) {
        dataFrame.release();
        return null;
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        Throwable t = ChannelCloseUtils.channelError((Channel)ctx.channel());
        if (t == null) {
            this.observer.streamClosed();
        } else {
            this.observer.streamClosed(t);
        }
        ctx.fireChannelInactive();
    }

    final long contentLength(Http2Headers headers) {
        if (this.contentLength == Long.MIN_VALUE) {
            this.contentLength = HeaderUtils.contentLength(headers.valueIterator((CharSequence)HttpHeaderNames.CONTENT_LENGTH), arg_0 -> ((Http2Headers)headers).getAll(arg_0));
        }
        return this.contentLength;
    }

    final void validateContentLengthMatch() {
        if (this.contentLength >= 0L && this.seenContentLength != this.contentLength) {
            throw this.newUnexpectedContentLength();
        }
    }

    private void updateSeenContentLength(int readableBytes) {
        assert (readableBytes >= 0);
        if (this.contentLength < 0L) {
            return;
        }
        this.seenContentLength = Math.addExact(this.seenContentLength, (long)readableBytes);
        if (this.seenContentLength > this.contentLength) {
            throw this.newUnexpectedContentLength();
        }
    }

    private IllegalArgumentException newUnexpectedContentLength() {
        throw new IllegalArgumentException("Expected content-length " + this.contentLength + " not equal to the actual length " + this.seenContentLength);
    }
}

