/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.netty.AlpnChannelSingle;
import io.servicetalk.http.netty.H2ServerParentConnectionContext;
import io.servicetalk.http.netty.NettyHttpServer;
import io.servicetalk.http.netty.ReadOnlyHttpServerConfig;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpServerConfig;
import io.servicetalk.tcp.netty.internal.TcpServerBinder;
import io.servicetalk.tcp.netty.internal.TcpServerChannelInitializer;
import io.servicetalk.transport.api.ConnectionAcceptor;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.ServerContext;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.NettyConnectionContext;
import java.net.SocketAddress;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AlpnServerContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlpnServerContext.class);

    private AlpnServerContext() {
    }

    static Single<ServerContext> bind(HttpExecutionContext executionContext, ReadOnlyHttpServerConfig config, SocketAddress listenAddress, @Nullable ConnectionAcceptor connectionAcceptor, StreamingHttpService service, boolean drainRequestPayloadBody) {
        assert (config.h1Config() != null && config.h2Config() != null);
        ReadOnlyTcpServerConfig tcpConfig = config.tcpConfig();
        assert (tcpConfig.sslContext() != null);
        return TcpServerBinder.bind((SocketAddress)listenAddress, (ReadOnlyTcpServerConfig)tcpConfig, (boolean)false, (ExecutionContext)executionContext, (ConnectionAcceptor)connectionAcceptor, (channel, connectionObserver) -> AlpnServerContext.initChannel(listenAddress, channel, config, executionContext, service, drainRequestPayloadBody, connectionObserver), serverConnection -> {
            if (serverConnection instanceof NettyHttpServer.NettyHttpServerConnection) {
                ((NettyHttpServer.NettyHttpServerConnection)((Object)serverConnection)).process(true);
            }
        }).map(delegate -> {
            LOGGER.debug("Started HTTP server with ALPN for address {}", (Object)delegate.listenAddress());
            return new NettyHttpServer.NettyHttpServerContext((ServerContext)delegate, service);
        });
    }

    private static Single<NettyConnectionContext> initChannel(SocketAddress listenAddress, Channel channel, ReadOnlyHttpServerConfig config, HttpExecutionContext httpExecutionContext, StreamingHttpService service, boolean drainRequestPayloadBody, ConnectionObserver observer) {
        return new AlpnChannelSingle(channel, (ChannelInitializer)new TcpServerChannelInitializer(config.tcpConfig(), observer), true).flatMap(protocol -> {
            switch (protocol) {
                case "http/1.1": {
                    return NettyHttpServer.initChannel(channel, httpExecutionContext, config, AlpnChannelSingle.NoopChannelInitializer.INSTANCE, service, drainRequestPayloadBody, observer);
                }
                case "h2": {
                    return H2ServerParentConnectionContext.initChannel(listenAddress, channel, httpExecutionContext, config, AlpnChannelSingle.NoopChannelInitializer.INSTANCE, service, drainRequestPayloadBody, observer);
                }
            }
            return Single.failed((Throwable)new IllegalStateException("Unknown ALPN protocol negotiated: " + protocol));
        });
    }
}

