/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.LoadBalancer;
import io.servicetalk.client.api.LoadBalancerFactory;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpLoadBalancedConnection;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpLoadBalancerFactory;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.loadbalancer.RoundRobinLoadBalancer;
import java.util.Objects;

public final class DefaultHttpLoadBalancerFactory<ResolvedAddress>
implements HttpLoadBalancerFactory<ResolvedAddress>,
HttpExecutionStrategyInfluencer {
    private final LoadBalancerFactory<ResolvedAddress, FilterableStreamingHttpLoadBalancedConnection> rawFactory;
    private final HttpExecutionStrategyInfluencer strategyInfluencer;

    DefaultHttpLoadBalancerFactory(LoadBalancerFactory<ResolvedAddress, FilterableStreamingHttpLoadBalancedConnection> rawFactory, HttpExecutionStrategyInfluencer strategyInfluencer) {
        this.rawFactory = rawFactory;
        this.strategyInfluencer = strategyInfluencer;
    }

    public <T extends FilterableStreamingHttpLoadBalancedConnection> LoadBalancer<T> newLoadBalancer(Publisher<? extends ServiceDiscovererEvent<ResolvedAddress>> eventPublisher, ConnectionFactory<ResolvedAddress, T> cf) {
        return this.rawFactory.newLoadBalancer(eventPublisher, cf);
    }

    public FilterableStreamingHttpLoadBalancedConnection toLoadBalancedConnection(FilterableStreamingHttpConnection connection) {
        return new DefaultFilterableStreamingHttpLoadBalancedConnection(connection);
    }

    public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
        return this.strategyInfluencer.influenceStrategy(strategy);
    }

    private static final class DefaultFilterableStreamingHttpLoadBalancedConnection
    implements FilterableStreamingHttpLoadBalancedConnection {
        private final FilterableStreamingHttpConnection delegate;

        DefaultFilterableStreamingHttpLoadBalancedConnection(FilterableStreamingHttpConnection delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        public int score() {
            return Integer.MAX_VALUE;
        }

        public HttpConnectionContext connectionContext() {
            return this.delegate.connectionContext();
        }

        public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
            return this.delegate.transportEventStream(eventKey);
        }

        public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
            return this.delegate.request(strategy, request);
        }

        public HttpExecutionContext executionContext() {
            return this.delegate.executionContext();
        }

        public StreamingHttpResponseFactory httpResponseFactory() {
            return this.delegate.httpResponseFactory();
        }

        public Completable onClose() {
            return this.delegate.onClose();
        }

        public Completable closeAsync() {
            return this.delegate.closeAsync();
        }

        public Completable closeAsyncGracefully() {
            return this.delegate.closeAsyncGracefully();
        }

        public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return this.delegate.newRequest(method, requestTarget);
        }
    }

    public static final class Builder<ResolvedAddress> {
        private final LoadBalancerFactory<ResolvedAddress, FilterableStreamingHttpLoadBalancedConnection> rawFactory;
        private final HttpExecutionStrategyInfluencer strategyInfluencer;

        private Builder(LoadBalancerFactory<ResolvedAddress, FilterableStreamingHttpLoadBalancedConnection> rawFactory, HttpExecutionStrategyInfluencer strategyInfluencer) {
            this.rawFactory = rawFactory;
            this.strategyInfluencer = strategyInfluencer;
        }

        public DefaultHttpLoadBalancerFactory<ResolvedAddress> build() {
            return new DefaultHttpLoadBalancerFactory<ResolvedAddress>(this.rawFactory, this.strategyInfluencer);
        }

        public static <ResolvedAddress> Builder<ResolvedAddress> fromDefaults() {
            return Builder.from(RoundRobinLoadBalancer.newRoundRobinFactory());
        }

        public static <ResolvedAddress> Builder<ResolvedAddress> from(LoadBalancerFactory<ResolvedAddress, FilterableStreamingHttpLoadBalancedConnection> rawFactory) {
            HttpExecutionStrategyInfluencer strategyInfluencer = rawFactory instanceof HttpExecutionStrategyInfluencer ? (HttpExecutionStrategyInfluencer)rawFactory : (rawFactory instanceof RoundRobinLoadBalancer.RoundRobinLoadBalancerFactory ? strategy -> strategy : HttpExecutionStrategyInfluencer.defaultStreamingInfluencer());
            return new Builder<ResolvedAddress>(rawFactory, strategyInfluencer);
        }
    }
}

