/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpServerBuilder;
import io.servicetalk.http.api.HttpServerSecurityConfigurator;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.netty.AlpnServerContext;
import io.servicetalk.http.netty.DefaultHttpServerSecurityConfigurator;
import io.servicetalk.http.netty.H2ServerParentConnectionContext;
import io.servicetalk.http.netty.HttpExecutionContextBuilder;
import io.servicetalk.http.netty.HttpServerConfig;
import io.servicetalk.http.netty.NettyHttpServer;
import io.servicetalk.http.netty.ReadOnlyHttpServerConfig;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.ConnectionAcceptor;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.api.ServerContext;
import io.servicetalk.transport.api.TransportObserver;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;

final class DefaultHttpServerBuilder
extends HttpServerBuilder {
    private final HttpServerConfig config = new HttpServerConfig();
    private final HttpExecutionContextBuilder executionContextBuilder = new HttpExecutionContextBuilder();
    private final SocketAddress address;

    DefaultHttpServerBuilder(SocketAddress address) {
        this.address = address;
    }

    public HttpServerBuilder protocols(HttpProtocolConfig ... protocols) {
        this.config.httpConfig().protocols(protocols);
        return this;
    }

    public HttpServerBuilder backlog(int backlog) {
        this.config.tcpConfig().backlog(backlog);
        return this;
    }

    public HttpServerSecurityConfigurator secure() {
        return new DefaultHttpServerSecurityConfigurator(securityConfig -> {
            this.config.tcpConfig().secure(securityConfig);
            return this;
        });
    }

    public HttpServerSecurityConfigurator secure(String ... sniHostnames) {
        return new DefaultHttpServerSecurityConfigurator(securityConfig -> {
            this.config.tcpConfig().secure(securityConfig, sniHostnames);
            return this;
        });
    }

    public <T> HttpServerBuilder socketOption(SocketOption<T> option, T value) {
        this.config.tcpConfig().socketOption(option, value);
        return this;
    }

    public HttpServerBuilder enableWireLogging(String loggerName) {
        this.config.tcpConfig().enableWireLogging(loggerName);
        return this;
    }

    public HttpServerBuilder enableWireLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
        this.config.tcpConfig().enableWireLogging(loggerName, logLevel, logUserData);
        return this;
    }

    public HttpServerBuilder transportObserver(TransportObserver transportObserver) {
        this.config.tcpConfig().transportObserver(transportObserver);
        return this;
    }

    public HttpServerBuilder allowDropRequestTrailers(boolean allowDrop) {
        this.config.httpConfig().allowDropTrailersReadFromTransport(allowDrop);
        return this;
    }

    public HttpServerBuilder ioExecutor(IoExecutor ioExecutor) {
        this.executionContextBuilder.ioExecutor(ioExecutor);
        return this;
    }

    public HttpServerBuilder bufferAllocator(BufferAllocator allocator) {
        this.executionContextBuilder.bufferAllocator(allocator);
        return this;
    }

    protected Single<ServerContext> doListen(@Nullable ConnectionAcceptor connectionAcceptor, StreamingHttpService service, HttpExecutionStrategy strategy, boolean drainRequestPayloadBody) {
        ReadOnlyHttpServerConfig roConfig = this.config.asReadOnly();
        this.executionContextBuilder.executionStrategy(strategy);
        HttpExecutionContext httpExecutionContext = this.executionContextBuilder.build();
        if (roConfig.isH2PriorKnowledge()) {
            return H2ServerParentConnectionContext.bind(httpExecutionContext, roConfig, this.address, connectionAcceptor, service, drainRequestPayloadBody);
        }
        return roConfig.tcpConfig().isAlpnConfigured() ? AlpnServerContext.bind(httpExecutionContext, roConfig, this.address, connectionAcceptor, service, drainRequestPayloadBody) : NettyHttpServer.bind(httpExecutionContext, roConfig, this.address, connectionAcceptor, service, drainRequestPayloadBody);
    }
}

