/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.http.api.HttpServerBuilder;
import io.servicetalk.http.api.HttpServerSecurityConfigurator;
import io.servicetalk.transport.api.SecurityConfigurator;
import io.servicetalk.transport.api.ServerSecurityConfigurator;
import io.servicetalk.transport.netty.internal.ReadOnlyServerSecurityConfig;
import io.servicetalk.transport.netty.internal.ServerSecurityConfig;
import java.io.InputStream;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

final class DefaultHttpServerSecurityConfigurator
implements HttpServerSecurityConfigurator {
    private final ServerSecurityConfig securityConfig = new ServerSecurityConfig();
    private final Function<ReadOnlyServerSecurityConfig, HttpServerBuilder> configConsumer;

    DefaultHttpServerSecurityConfigurator(Function<ReadOnlyServerSecurityConfig, HttpServerBuilder> configConsumer) {
        this.configConsumer = configConsumer;
    }

    public HttpServerSecurityConfigurator trustManager(Supplier<InputStream> trustCertChainSupplier) {
        this.securityConfig.trustManager(trustCertChainSupplier);
        return this;
    }

    public HttpServerSecurityConfigurator trustManager(TrustManagerFactory trustManagerFactory) {
        this.securityConfig.trustManager(trustManagerFactory);
        return this;
    }

    public HttpServerSecurityConfigurator protocols(String ... protocols) {
        this.securityConfig.protocols(protocols);
        return this;
    }

    public HttpServerSecurityConfigurator ciphers(Iterable<String> ciphers) {
        this.securityConfig.ciphers(ciphers);
        return this;
    }

    public HttpServerSecurityConfigurator sessionCacheSize(long sessionCacheSize) {
        this.securityConfig.sessionCacheSize(sessionCacheSize);
        return this;
    }

    public HttpServerSecurityConfigurator sessionTimeout(long sessionTimeout) {
        this.securityConfig.sessionTimeout(sessionTimeout);
        return this;
    }

    public HttpServerSecurityConfigurator provider(SecurityConfigurator.SslProvider provider) {
        this.securityConfig.provider(provider);
        return this;
    }

    public HttpServerSecurityConfigurator clientAuth(ServerSecurityConfigurator.ClientAuth clientAuth) {
        this.securityConfig.clientAuth(clientAuth);
        return this;
    }

    public HttpServerBuilder commit(KeyManagerFactory keyManagerFactory) {
        this.securityConfig.keyManager(keyManagerFactory);
        return this.configConsumer.apply(this.securityConfig.asReadOnly());
    }

    public HttpServerBuilder commit(Supplier<InputStream> keyCertChainSupplier, Supplier<InputStream> keySupplier) {
        this.securityConfig.keyManager(keyCertChainSupplier, keySupplier);
        return this.configConsumer.apply(this.securityConfig.asReadOnly());
    }

    public HttpServerBuilder commit(Supplier<InputStream> keyCertChainSupplier, Supplier<InputStream> keySupplier, String keyPassword) {
        this.securityConfig.keyManager(keyCertChainSupplier, keySupplier, keyPassword);
        return this.configConsumer.apply(this.securityConfig.asReadOnly());
    }
}

