/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.BlockingHttpConnection;
import io.servicetalk.http.api.BlockingStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpConnection;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.StreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;

final class FilterableConnectionToConnection
implements StreamingHttpConnection {
    private final FilterableStreamingHttpConnection filteredConnection;
    private final HttpExecutionStrategy streamingStrategy;
    private final HttpExecutionStrategyInfluencer strategyInfluencer;

    FilterableConnectionToConnection(FilterableStreamingHttpConnection filteredConnection, HttpExecutionStrategy streamingStrategy, HttpExecutionStrategyInfluencer strategyInfluencer) {
        this.filteredConnection = filteredConnection;
        this.streamingStrategy = streamingStrategy;
        this.strategyInfluencer = strategyInfluencer;
    }

    public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
        return this.request(this.streamingStrategy, request);
    }

    public HttpConnection asConnection() {
        return HttpApiConversions.toConnection((StreamingHttpConnection)this, (HttpExecutionStrategyInfluencer)this.strategyInfluencer);
    }

    public BlockingStreamingHttpConnection asBlockingStreamingConnection() {
        return HttpApiConversions.toBlockingStreamingConnection((StreamingHttpConnection)this, (HttpExecutionStrategyInfluencer)this.strategyInfluencer);
    }

    public BlockingHttpConnection asBlockingConnection() {
        return HttpApiConversions.toBlockingConnection((StreamingHttpConnection)this, (HttpExecutionStrategyInfluencer)this.strategyInfluencer);
    }

    public HttpConnectionContext connectionContext() {
        return this.filteredConnection.connectionContext();
    }

    public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
        return this.filteredConnection.transportEventStream(eventKey);
    }

    public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
        return this.filteredConnection.request(strategy, request);
    }

    public HttpExecutionContext executionContext() {
        return this.filteredConnection.executionContext();
    }

    public StreamingHttpResponseFactory httpResponseFactory() {
        return this.filteredConnection.httpResponseFactory();
    }

    public Completable onClose() {
        return this.filteredConnection.onClose();
    }

    public Completable closeAsync() {
        return this.filteredConnection.closeAsync();
    }

    public Completable closeAsyncGracefully() {
        return this.filteredConnection.closeAsyncGracefully();
    }

    public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return this.filteredConnection.newRequest(method, requestTarget);
    }
}

