/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.dns.discovery.netty.DefaultDnsServiceDiscovererBuilder;
import io.servicetalk.transport.api.HostAndPort;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GlobalDnsServiceDiscoverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalDnsServiceDiscoverer.class);

    private GlobalDnsServiceDiscoverer() {
    }

    static ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> globalDnsServiceDiscoverer() {
        return HostAndPortClientInitializer.HOST_PORT_SD;
    }

    static ServiceDiscoverer<String, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> globalSrvDnsServiceDiscoverer() {
        return SrvClientInitializer.SRV_SD;
    }

    private static final class SrvClientInitializer {
        static final ServiceDiscoverer<String, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> SRV_SD = new DefaultDnsServiceDiscovererBuilder().buildSrvDiscoverer();

        private SrvClientInitializer() {
        }

        static {
            LOGGER.debug("Initialized SrvClientInitializer");
        }
    }

    private static final class HostAndPortClientInitializer {
        static final ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> HOST_PORT_SD = new DefaultDnsServiceDiscovererBuilder().buildARecordDiscoverer();

        private HostAndPortClientInitializer() {
        }

        static {
            LOGGER.debug("Initialized HostAndPortClientInitializer");
        }
    }
}

