/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.netty.NettyH2HeadersToHttpHeaders;
import java.util.function.BiPredicate;

public final class H2HeadersFactory
implements HttpHeadersFactory {
    public static final HttpHeadersFactory INSTANCE = new H2HeadersFactory(true, true);
    static final BiPredicate<CharSequence, CharSequence> DEFAULT_SENSITIVITY_DETECTOR = (name, value) -> false;
    private final boolean validateNames;
    private final boolean validateCookies;
    private final int headersArraySizeHint;
    private final int trailersArraySizeHint;

    public H2HeadersFactory(boolean validateNames, boolean validateCookies) {
        this(validateNames, validateCookies, 16, 4);
    }

    public H2HeadersFactory(boolean validateNames, boolean validateCookies, int headersArraySizeHint, int trailersArraySizeHint) {
        this.validateNames = validateNames;
        this.validateCookies = validateCookies;
        this.headersArraySizeHint = headersArraySizeHint;
        this.trailersArraySizeHint = trailersArraySizeHint;
    }

    public HttpHeaders newHeaders() {
        return new NettyH2HeadersToHttpHeaders((Http2Headers)new DefaultHttp2Headers(this.validateNames, this.headersArraySizeHint), this.validateCookies);
    }

    public HttpHeaders newTrailers() {
        return new NettyH2HeadersToHttpHeaders((Http2Headers)new DefaultHttp2Headers(this.validateNames, this.trailersArraySizeHint), this.validateCookies);
    }

    public HttpHeaders newEmptyTrailers() {
        return new NettyH2HeadersToHttpHeaders((Http2Headers)new DefaultHttp2Headers(this.validateNames, 0), this.validateCookies);
    }

    public boolean validateCookies() {
        return this.validateCookies;
    }
}

