/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2PingFrame;
import io.netty.handler.codec.http2.Http2SettingsAckFrame;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.ReferenceCountUtil;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Processors;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.http.api.DefaultHttpExecutionContext;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.netty.Http2Exception;
import io.servicetalk.http.netty.KeepAliveManager;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.netty.internal.ChannelCloseUtils;
import io.servicetalk.transport.netty.internal.FlushStrategy;
import io.servicetalk.transport.netty.internal.FlushStrategyHolder;
import io.servicetalk.transport.netty.internal.NettyChannelListenableAsyncCloseable;
import io.servicetalk.transport.netty.internal.NettyConnectionContext;
import io.servicetalk.transport.netty.internal.NettyIoExecutors;
import io.servicetalk.transport.netty.internal.NettyPipelineSslUtils;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import io.servicetalk.transport.netty.internal.SocketOptionUtils;
import io.servicetalk.transport.netty.internal.StacklessClosedChannelException;
import java.net.SocketAddress;
import java.net.SocketOption;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;

class H2ParentConnectionContext
extends NettyChannelListenableAsyncCloseable
implements NettyConnectionContext,
HttpConnectionContext {
    final FlushStrategyHolder flushStrategyHolder;
    private final HttpExecutionContext executionContext;
    private final SingleSource.Processor<Throwable, Throwable> transportError = Processors.newSingleProcessor();
    private final CompletableSource.Processor onClosing = Processors.newCompletableProcessor();
    private final KeepAliveManager keepAliveManager;
    @Nullable
    final Long idleTimeoutMs;
    @Nullable
    private SSLSession sslSession;

    H2ParentConnectionContext(Channel channel, BufferAllocator allocator, Executor executor, FlushStrategy flushStrategy, @Nullable Long idleTimeoutMs, HttpExecutionStrategy executionStrategy, KeepAliveManager keepAliveManager) {
        super(channel, executor);
        this.executionContext = new DefaultHttpExecutionContext(allocator, (IoExecutor)NettyIoExecutors.fromNettyEventLoop((EventLoop)channel.eventLoop()), executor, executionStrategy);
        this.flushStrategyHolder = new FlushStrategyHolder(flushStrategy);
        this.idleTimeoutMs = idleTimeoutMs;
        this.keepAliveManager = keepAliveManager;
        this.onClose().subscribe(() -> ((CompletableSource.Processor)this.onClosing).onComplete());
    }

    public final Cancellable updateFlushStrategy(NettyConnectionContext.FlushStrategyProvider strategyProvider) {
        return this.flushStrategyHolder.updateFlushStrategy(strategyProvider);
    }

    public FlushStrategy defaultFlushStrategy() {
        return this.flushStrategyHolder.currentStrategy();
    }

    public final Single<Throwable> transportError() {
        return SourceAdapters.fromSource(this.transportError).publishOn(this.executionContext().executor());
    }

    public final Completable onClosing() {
        return SourceAdapters.fromSource((CompletableSource)this.onClosing).publishOn(this.executionContext().executor());
    }

    public final SocketAddress localAddress() {
        return this.channel().localAddress();
    }

    public final SocketAddress remoteAddress() {
        return this.channel().remoteAddress();
    }

    @Nullable
    public final SSLSession sslSession() {
        return this.sslSession;
    }

    public final HttpExecutionContext executionContext() {
        return this.executionContext;
    }

    @Nullable
    public <T> T socketOption(SocketOption<T> option) {
        return (T)SocketOptionUtils.getOption(option, (ChannelConfig)this.channel().config(), (Long)this.idleTimeoutMs);
    }

    public HttpProtocolVersion protocol() {
        return HttpProtocolVersion.HTTP_2_0;
    }

    public final Channel nettyChannel() {
        return this.channel();
    }

    public final String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + '(' + this.channel() + ')';
    }

    protected final void doCloseAsyncGracefully() {
        this.keepAliveManager.initiateGracefulClose(() -> ((CompletableSource.Processor)this.onClosing).onComplete());
    }

    final void trackActiveStream(Channel streamChannel) {
        this.keepAliveManager.trackActiveStream(streamChannel);
    }

    static abstract class AbstractH2ParentConnection
    extends ChannelInboundHandlerAdapter {
        final H2ParentConnectionContext parentContext;
        final boolean waitForSslHandshake;
        private final DelayedCancellable delayedCancellable;
        final ConnectionObserver observer;

        AbstractH2ParentConnection(H2ParentConnectionContext parentContext, DelayedCancellable delayedCancellable, boolean waitForSslHandshake, ConnectionObserver observer) {
            this.parentContext = parentContext;
            this.delayedCancellable = delayedCancellable;
            this.waitForSslHandshake = waitForSslHandshake;
            this.observer = observer;
        }

        abstract boolean hasSubscriber();

        abstract void tryCompleteSubscriber();

        abstract void tryFailSubscriber(Throwable var1);

        abstract boolean ackSettings(ChannelHandlerContext var1, Http2SettingsFrame var2);

        public final void handlerAdded(ChannelHandlerContext ctx) {
            Channel channel = ctx.channel();
            this.delayedCancellable.delayedCancellable(() -> ((Channel)channel).close());
            if (channel.isActive()) {
                this.doChannelActive(ctx);
            }
            if (!channel.config().isAutoRead()) {
                channel.config().setAutoRead(true);
            }
        }

        public final void channelActive(ChannelHandlerContext ctx) {
            this.doChannelActive(ctx);
        }

        public final void channelInactive(ChannelHandlerContext ctx) {
            if (this.hasSubscriber()) {
                this.tryFailSubscriber((Throwable)StacklessClosedChannelException.newInstance(H2ParentConnectionContext.class, (String)"channelInactive(...)"));
            }
            this.parentContext.keepAliveManager.channelClosed();
        }

        public final void handlerRemoved(ChannelHandlerContext ctx) {
            if (this.hasSubscriber()) {
                this.tryFailSubscriber((Throwable)StacklessClosedChannelException.newInstance(H2ParentConnectionContext.class, (String)"handlerRemoved(...)"));
            }
            this.parentContext.keepAliveManager.channelClosed();
        }

        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            cause = Http2Exception.wrapIfNecessary(cause);
            if (this.observer != NoopTransportObserver.NoopConnectionObserver.INSTANCE) {
                ChannelCloseUtils.assignConnectionError((Channel)ctx.channel(), (Throwable)cause);
            }
            this.parentContext.transportError.onSuccess((Object)cause);
        }

        public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            try {
                if (evt instanceof SslHandshakeCompletionEvent) {
                    this.parentContext.sslSession = NettyPipelineSslUtils.extractSslSessionAndReport((ChannelPipeline)ctx.pipeline(), (SslHandshakeCompletionEvent)((SslHandshakeCompletionEvent)evt), this::tryFailSubscriber, (this.observer != NoopTransportObserver.NoopConnectionObserver.INSTANCE ? 1 : 0) != 0);
                    this.tryCompleteSubscriber();
                }
            }
            finally {
                ReferenceCountUtil.release((Object)evt);
            }
        }

        public final void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof Http2SettingsFrame) {
                if (this.ackSettings(ctx, (Http2SettingsFrame)msg)) {
                    ctx.writeAndFlush((Object)Http2SettingsAckFrame.INSTANCE);
                }
            } else if (msg instanceof Http2GoAwayFrame) {
                Http2GoAwayFrame goAwayFrame = (Http2GoAwayFrame)msg;
                goAwayFrame.release();
                this.parentContext.onClosing.onComplete();
                this.parentContext.keepAliveManager.initiateGracefulClose(() -> ((CompletableSource.Processor)this.parentContext.onClosing).onComplete());
            } else if (msg instanceof Http2PingFrame) {
                this.parentContext.keepAliveManager.pingReceived((Http2PingFrame)msg);
            } else if (!(msg instanceof Http2SettingsAckFrame)) {
                ctx.fireChannelRead(msg);
            }
        }

        private void doChannelActive(ChannelHandlerContext ctx) {
            if (this.waitForSslHandshake) {
                ctx.read();
            } else {
                this.tryCompleteSubscriber();
            }
        }
    }
}

