/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.netty.H2HeadersFactory;
import io.servicetalk.http.netty.H2KeepAlivePolicies;
import io.servicetalk.http.netty.H2ProtocolConfig;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.logging.api.UserDataLoggerConfig;
import io.servicetalk.logging.slf4j.internal.DefaultUserDataLoggerConfig;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;

public final class H2ProtocolConfigBuilder {
    private HttpHeadersFactory headersFactory = H2HeadersFactory.INSTANCE;
    private BiPredicate<CharSequence, CharSequence> headersSensitivityDetector = H2HeadersFactory.DEFAULT_SENSITIVITY_DETECTOR;
    @Nullable
    private UserDataLoggerConfig frameLoggerConfig;
    @Nullable
    private H2ProtocolConfig.KeepAlivePolicy keepAlivePolicy;

    H2ProtocolConfigBuilder() {
    }

    public H2ProtocolConfigBuilder headersFactory(HttpHeadersFactory headersFactory) {
        this.headersFactory = Objects.requireNonNull(headersFactory);
        return this;
    }

    public H2ProtocolConfigBuilder headersSensitivityDetector(BiPredicate<CharSequence, CharSequence> headersSensitivityDetector) {
        this.headersSensitivityDetector = Objects.requireNonNull(headersSensitivityDetector);
        return this;
    }

    @Deprecated
    public H2ProtocolConfigBuilder enableFrameLogging(String loggerName) {
        return this.enableFrameLogging(loggerName, LogLevel.TRACE, () -> false);
    }

    public H2ProtocolConfigBuilder enableFrameLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
        this.frameLoggerConfig = new DefaultUserDataLoggerConfig(loggerName, logLevel, logUserData);
        return this;
    }

    public H2ProtocolConfigBuilder keepAlivePolicy(H2ProtocolConfig.KeepAlivePolicy policy) {
        this.keepAlivePolicy = policy == H2KeepAlivePolicies.DISABLE_KEEP_ALIVE ? null : Objects.requireNonNull(policy);
        return this;
    }

    public H2ProtocolConfig build() {
        return new DefaultH2ProtocolConfig(this.headersFactory, this.headersSensitivityDetector, this.frameLoggerConfig, this.keepAlivePolicy);
    }

    private static final class DefaultH2ProtocolConfig
    implements H2ProtocolConfig {
        private final HttpHeadersFactory headersFactory;
        private final BiPredicate<CharSequence, CharSequence> headersSensitivityDetector;
        @Nullable
        private final UserDataLoggerConfig frameLoggerConfig;
        @Nullable
        private final H2ProtocolConfig.KeepAlivePolicy keepAlivePolicy;

        DefaultH2ProtocolConfig(HttpHeadersFactory headersFactory, BiPredicate<CharSequence, CharSequence> headersSensitivityDetector, @Nullable UserDataLoggerConfig frameLoggerConfig, @Nullable H2ProtocolConfig.KeepAlivePolicy keepAlivePolicy) {
            this.headersFactory = headersFactory;
            this.headersSensitivityDetector = headersSensitivityDetector;
            this.frameLoggerConfig = frameLoggerConfig;
            this.keepAlivePolicy = keepAlivePolicy;
        }

        public HttpHeadersFactory headersFactory() {
            return this.headersFactory;
        }

        @Override
        public BiPredicate<CharSequence, CharSequence> headersSensitivityDetector() {
            return this.headersSensitivityDetector;
        }

        @Override
        @Nullable
        public UserDataLoggerConfig frameLoggerConfig() {
            return this.frameLoggerConfig;
        }

        @Override
        @Nullable
        public H2ProtocolConfig.KeepAlivePolicy keepAlivePolicy() {
            return this.keepAlivePolicy;
        }
    }
}

