/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.util.AsciiString;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.ScanWithMapper;
import io.servicetalk.http.api.EmptyHttpHeaders;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class HeaderUtils {
    static final Predicate<Object> LAST_CHUNK_PREDICATE = p -> p instanceof HttpHeaders;

    private HeaderUtils() {
    }

    static int indexOf(CharSequence sequence, char c, int fromIndex) {
        return sequence instanceof AsciiString ? ((AsciiString)sequence).indexOf(c, fromIndex) : CharSequences.indexOf((CharSequence)sequence, (char)c, (int)fromIndex);
    }

    static void removeTransferEncodingChunked(HttpHeaders headers) {
        Iterator itr = headers.valuesIterator(HttpHeaderNames.TRANSFER_ENCODING);
        while (itr.hasNext()) {
            if (!HttpHeaderValues.CHUNKED.contentEqualsIgnoreCase((CharSequence)itr.next())) continue;
            itr.remove();
        }
    }

    static boolean canAddRequestContentLength(StreamingHttpRequest request) {
        return HeaderUtils.canAddContentLength((HttpMetaData)request) && HeaderUtils.clientMaySendPayloadBodyFor(request.method());
    }

    static boolean canAddResponseContentLength(StreamingHttpResponse response, HttpRequestMethod requestMethod) {
        return HeaderUtils.canAddContentLength((HttpMetaData)response) && HeaderUtils.shouldAddZeroContentLength(response.status().code(), requestMethod) && !HeaderUtils.isHeadResponse(requestMethod);
    }

    static boolean canAddRequestTransferEncoding(StreamingHttpRequest request) {
        return !HeaderUtils.hasContentHeaders(request.headers()) && HeaderUtils.clientMaySendPayloadBodyFor(request.method());
    }

    static boolean clientMaySendPayloadBodyFor(HttpRequestMethod requestMethod) {
        return !HttpRequestMethod.TRACE.equals((Object)requestMethod);
    }

    static boolean canAddResponseTransferEncoding(StreamingHttpResponse response, HttpRequestMethod requestMethod) {
        return !HeaderUtils.hasContentHeaders(response.headers()) && HeaderUtils.canAddResponseTransferEncodingProtocol(response.status().code(), requestMethod);
    }

    static boolean canAddResponseTransferEncodingProtocol(int statusCode, HttpRequestMethod requestMethod) {
        return !HttpRequestMethod.HEAD.equals((Object)requestMethod) && !HeaderUtils.isEmptyResponseStatus(statusCode) && !HeaderUtils.isEmptyConnectResponse(requestMethod, statusCode);
    }

    private static boolean canAddContentLength(HttpMetaData metadata) {
        return !HeaderUtils.hasContentHeaders(metadata.headers()) && HttpApiConversions.isSafeToAggregate((HttpMetaData)metadata) && !HttpApiConversions.mayHaveTrailers((HttpMetaData)metadata);
    }

    static Publisher<Object> setRequestContentLength(StreamingHttpRequest request) {
        return HeaderUtils.setContentLength((HttpMetaData)request, (Publisher<Object>)request.messageBody(), HeaderUtils.shouldAddZeroContentLength(request.method()) ? HeaderUtils::updateRequestContentLength : HeaderUtils::updateRequestContentLengthNonZero);
    }

    static Publisher<Object> setResponseContentLength(StreamingHttpResponse response) {
        return HeaderUtils.setContentLength((HttpMetaData)response, (Publisher<Object>)response.messageBody(), HeaderUtils::updateResponseContentLength);
    }

    private static void updateRequestContentLengthNonZero(int contentLength, HttpHeaders headers) {
        if (contentLength > 0) {
            headers.set(HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(contentLength));
        }
    }

    private static void updateRequestContentLength(int contentLength, HttpHeaders headers) {
        assert (contentLength >= 0);
        headers.set(HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(contentLength));
    }

    static boolean shouldAddZeroContentLength(HttpRequestMethod requestMethod) {
        return HttpRequestMethod.POST.equals((Object)requestMethod) || HttpRequestMethod.PUT.equals((Object)requestMethod) || HttpRequestMethod.PATCH.equals((Object)requestMethod);
    }

    static boolean shouldAddZeroContentLength(int statusCode, HttpRequestMethod requestMethod) {
        return !HeaderUtils.isEmptyResponseStatus(statusCode) && !HeaderUtils.isEmptyConnectResponse(requestMethod, statusCode);
    }

    static ScanWithMapper<Object, Object> insertTrailersMapper() {
        return new ScanWithMapper<Object, Object>(){
            @Nullable
            private boolean sawHeaders;

            @Nullable
            public Object mapOnNext(@Nullable Object next) {
                if (next instanceof HttpHeaders) {
                    this.sawHeaders = true;
                }
                return next;
            }

            @Nullable
            public Object mapOnError(Throwable t) throws Throwable {
                throw t;
            }

            public Object mapOnComplete() {
                return EmptyHttpHeaders.INSTANCE;
            }

            public boolean mapTerminal() {
                return !this.sawHeaders;
            }
        };
    }

    private static boolean isHeadResponse(HttpRequestMethod requestMethod) {
        return HttpRequestMethod.HEAD.equals((Object)requestMethod);
    }

    private static void updateResponseContentLength(int contentLength, HttpHeaders headers) {
        headers.set(HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(contentLength));
    }

    private static Publisher<Object> setContentLength(HttpMetaData metadata, Publisher<Object> messageBody, BiIntConsumer<HttpHeaders> contentLengthUpdater) {
        return messageBody.collect(() -> null, (reduction, item) -> {
            ArrayList<Object> items;
            if (reduction == null) {
                return item;
            }
            if (reduction instanceof List) {
                ArrayList<Object> itemsUnchecked;
                items = itemsUnchecked = (ArrayList<Object>)reduction;
            } else {
                items = new ArrayList<Object>(2);
                items.add(reduction);
            }
            items.add(item);
            return items;
        }).flatMapPublisher(reduction -> {
            Publisher flatRequest;
            int contentLength = 0;
            if (reduction == null) {
                flatRequest = Publisher.from((Object[])new Object[]{metadata, EmptyHttpHeaders.INSTANCE});
            } else if (reduction instanceof Buffer) {
                Buffer buffer = (Buffer)reduction;
                contentLength = buffer.readableBytes();
                flatRequest = Publisher.from((Object[])new Object[]{metadata, buffer, EmptyHttpHeaders.INSTANCE});
            } else if (reduction instanceof List) {
                List items = (List)reduction;
                for (Object item : items) {
                    if (!(item instanceof Buffer)) continue;
                    contentLength += ((Buffer)item).readableBytes();
                }
                if (!(items.get(items.size() - 1) instanceof HttpHeaders)) {
                    items.add(EmptyHttpHeaders.INSTANCE);
                }
                flatRequest = Publisher.from((Object)metadata).concat(Publisher.fromIterable((Iterable)items));
            } else if (reduction instanceof HttpHeaders) {
                flatRequest = Publisher.from((Object[])new Object[]{metadata, reduction});
            } else {
                throw new IllegalArgumentException("unsupported payload chunk type: " + reduction);
            }
            contentLengthUpdater.apply(contentLength, metadata.headers());
            return flatRequest;
        });
    }

    static StreamingHttpResponse addResponseTransferEncodingIfNecessary(StreamingHttpResponse response, HttpRequestMethod requestMethod) {
        if (HeaderUtils.canAddResponseTransferEncoding(response, requestMethod)) {
            response.headers().add(HttpHeaderNames.TRANSFER_ENCODING, io.servicetalk.http.api.HttpHeaderValues.CHUNKED);
        }
        return response;
    }

    static void addRequestTransferEncodingIfNecessary(StreamingHttpRequest request) {
        if (HeaderUtils.canAddRequestTransferEncoding(request)) {
            request.headers().add(HttpHeaderNames.TRANSFER_ENCODING, io.servicetalk.http.api.HttpHeaderValues.CHUNKED);
        }
    }

    private static boolean hasContentHeaders(HttpHeaders headers) {
        return headers.contains(HttpHeaderNames.CONTENT_LENGTH) || io.servicetalk.http.api.HeaderUtils.isTransferEncodingChunked((HttpHeaders)headers);
    }

    private static boolean isEmptyConnectResponse(HttpRequestMethod requestMethod, int statusCode) {
        return HttpRequestMethod.CONNECT.equals((Object)requestMethod) && HttpResponseStatus.StatusClass.SUCCESSFUL_2XX.contains(statusCode);
    }

    private static boolean isEmptyResponseStatus(int statusCode) {
        return HttpResponseStatus.StatusClass.INFORMATIONAL_1XX.contains(statusCode) || statusCode == HttpResponseStatus.NO_CONTENT.code();
    }

    static long contentLength(Iterator<? extends CharSequence> iterator, Function<CharSequence, Iterable<? extends CharSequence>> valuesExtractor) {
        if (!iterator.hasNext()) {
            return -1L;
        }
        CharSequence firstValue = iterator.next();
        if (iterator.hasNext() || CharSequences.indexOf((CharSequence)firstValue, (char)',', (int)0) >= 0) {
            throw new IllegalArgumentException("Multiple content-length values found: " + valuesExtractor.apply(HttpHeaderNames.CONTENT_LENGTH));
        }
        return Long.parseLong(firstValue.toString());
    }

    @FunctionalInterface
    private static interface BiIntConsumer<T> {
        public void apply(int var1, T var2);
    }
}

