/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.netty.H1ProtocolConfig;
import io.servicetalk.http.netty.HttpRequestEncoder;
import io.servicetalk.http.netty.HttpResponseDecoder;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.transport.netty.internal.CopyByteBufHandlerChannelInitializer;
import java.util.ArrayDeque;

final class HttpClientChannelInitializer
implements ChannelInitializer {
    private final ChannelInitializer delegate;

    HttpClientChannelInitializer(ByteBufAllocator alloc, H1ProtocolConfig config, CloseHandler closeHandler) {
        this.delegate = new CopyByteBufHandlerChannelInitializer(alloc).andThen(channel -> {
            ArrayDeque<HttpRequestMethod> methodQueue = new ArrayDeque<HttpRequestMethod>(Math.min(8, config.maxPipelinedRequests()));
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.addLast(new ChannelHandler[]{new HttpResponseDecoder(methodQueue, alloc, config.headersFactory(), config.maxStartLineLength(), config.maxHeaderFieldLength(), config.specExceptions().allowPrematureClosureBeforePayloadBody(), closeHandler)});
            pipeline.addLast(new ChannelHandler[]{new HttpRequestEncoder(methodQueue, config.headersEncodedSizeEstimate(), config.trailersEncodedSizeEstimate(), closeHandler)});
        });
    }

    public void init(Channel channel) {
        this.delegate.init(channel);
    }
}

