/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.internal.RequestConcurrencyController;
import io.servicetalk.client.api.internal.ReservableRequestConcurrencyController;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpLoadBalancedConnection;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.ReservedBlockingHttpConnection;
import io.servicetalk.http.api.ReservedBlockingStreamingHttpConnection;
import io.servicetalk.http.api.ReservedHttpConnection;
import io.servicetalk.http.api.ReservedStreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import java.util.Objects;

final class LoadBalancedStreamingHttpConnection
implements FilterableStreamingHttpLoadBalancedConnection,
ReservedStreamingHttpConnection,
ReservableRequestConcurrencyController,
HttpExecutionStrategyInfluencer {
    private final ReservableRequestConcurrencyController limiter;
    private final FilterableStreamingHttpLoadBalancedConnection filteredConnection;
    private final HttpExecutionStrategy streamingStrategy;
    private final HttpExecutionStrategyInfluencer strategyInfluencer;

    LoadBalancedStreamingHttpConnection(FilterableStreamingHttpLoadBalancedConnection filteredConnection, ReservableRequestConcurrencyController limiter, HttpExecutionStrategy streamingStrategy, HttpExecutionStrategyInfluencer strategyInfluencer) {
        this.filteredConnection = filteredConnection;
        this.limiter = Objects.requireNonNull(limiter);
        this.streamingStrategy = streamingStrategy;
        this.strategyInfluencer = strategyInfluencer;
    }

    public boolean tryReserve() {
        return this.limiter.tryReserve();
    }

    public RequestConcurrencyController.Result tryRequest() {
        return this.limiter.tryRequest();
    }

    public void requestFinished() {
        this.limiter.requestFinished();
    }

    public Completable releaseAsync() {
        return this.limiter.releaseAsync();
    }

    public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
        return this.filteredConnection.request(this.streamingStrategy, request);
    }

    public HttpConnectionContext connectionContext() {
        return this.filteredConnection.connectionContext();
    }

    public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
        return this.filteredConnection.transportEventStream(eventKey);
    }

    public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
        return this.filteredConnection.request(strategy, request);
    }

    public HttpExecutionContext executionContext() {
        return this.filteredConnection.executionContext();
    }

    public StreamingHttpResponseFactory httpResponseFactory() {
        return this.filteredConnection.httpResponseFactory();
    }

    public Completable onClose() {
        return this.filteredConnection.onClose();
    }

    public Completable closeAsync() {
        return this.filteredConnection.closeAsync();
    }

    public Completable closeAsyncGracefully() {
        return this.filteredConnection.closeAsyncGracefully();
    }

    public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return this.filteredConnection.newRequest(method, requestTarget);
    }

    public ReservedHttpConnection asConnection() {
        return HttpApiConversions.toReservedConnection((ReservedStreamingHttpConnection)this, (HttpExecutionStrategyInfluencer)this.strategyInfluencer);
    }

    public ReservedBlockingStreamingHttpConnection asBlockingStreamingConnection() {
        return HttpApiConversions.toReservedBlockingStreamingConnection((ReservedStreamingHttpConnection)this, (HttpExecutionStrategyInfluencer)this.strategyInfluencer);
    }

    public ReservedBlockingHttpConnection asBlockingConnection() {
        return HttpApiConversions.toReservedBlockingConnection((ReservedStreamingHttpConnection)this, (HttpExecutionStrategyInfluencer)this.strategyInfluencer);
    }

    public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
        return this.strategyInfluencer.influenceStrategy(strategy);
    }

    public int score() {
        return this.filteredConnection.score();
    }
}

