/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.http.netty.H1ProtocolConfig;
import io.servicetalk.http.netty.H2ProtocolConfig;
import io.servicetalk.http.netty.HttpConfig;
import io.servicetalk.http.netty.HttpServerConfig;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpServerConfig;
import javax.annotation.Nullable;

final class ReadOnlyHttpServerConfig {
    private final ReadOnlyTcpServerConfig tcpConfig;
    @Nullable
    private final H1ProtocolConfig h1Config;
    @Nullable
    private final H2ProtocolConfig h2Config;
    private final boolean allowDropTrailers;

    ReadOnlyHttpServerConfig(HttpServerConfig from) {
        HttpConfig configs = from.httpConfig();
        this.tcpConfig = from.tcpConfig().asReadOnly(configs.supportedAlpnProtocols());
        this.h1Config = configs.h1Config();
        this.h2Config = configs.h2Config();
        this.allowDropTrailers = configs.allowDropTrailersReadFromTransport();
    }

    ReadOnlyTcpServerConfig tcpConfig() {
        return this.tcpConfig;
    }

    @Nullable
    H1ProtocolConfig h1Config() {
        return this.h1Config;
    }

    @Nullable
    H2ProtocolConfig h2Config() {
        return this.h2Config;
    }

    boolean allowDropTrailersReadFromTransport() {
        return this.allowDropTrailers;
    }

    boolean isH2PriorKnowledge() {
        return this.h2Config != null && this.h1Config == null;
    }
}

