/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.netty.BufferUtils;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.HttpClientChannelInitializer;
import io.servicetalk.http.netty.HttpDebugUtils;
import io.servicetalk.http.netty.ReadOnlyHttpClientConfig;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpClientConfig;
import io.servicetalk.tcp.netty.internal.TcpClientChannelInitializer;
import io.servicetalk.tcp.netty.internal.TcpConnector;
import io.servicetalk.transport.api.ConnectionInfo;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.transport.netty.internal.DefaultNettyConnection;
import io.servicetalk.transport.netty.internal.FlushStrategy;
import io.servicetalk.transport.netty.internal.NettyConnection;

final class StreamingConnectionFactory {
    private StreamingConnectionFactory() {
    }

    static <ResolvedAddress> Single<? extends NettyConnection<Object, Object>> buildStreaming(HttpExecutionContext executionContext, ResolvedAddress resolvedAddress, ReadOnlyHttpClientConfig roConfig, TransportObserver observer) {
        return TcpConnector.connect(null, resolvedAddress, (ReadOnlyTcpClientConfig)roConfig.tcpConfig(), (boolean)false, (ExecutionContext)executionContext, (channel, connectionObserver) -> StreamingConnectionFactory.createConnection(channel, executionContext, roConfig, (ChannelInitializer)new TcpClientChannelInitializer(roConfig.tcpConfig(), connectionObserver, roConfig.hasProxy()), connectionObserver), (TransportObserver)observer);
    }

    static Single<? extends DefaultNettyConnection<Object, Object>> createConnection(Channel channel, HttpExecutionContext executionContext, ReadOnlyHttpClientConfig config, ChannelInitializer initializer, ConnectionObserver connectionObserver) {
        CloseHandler closeHandler = CloseHandler.forPipelinedRequestResponse((boolean)true, (ChannelConfig)channel.config());
        assert (config.h1Config() != null);
        return HttpDebugUtils.showPipeline(DefaultNettyConnection.initChannel((Channel)channel, (BufferAllocator)executionContext.bufferAllocator(), (Executor)executionContext.executor(), HeaderUtils.LAST_CHUNK_PREDICATE, (CloseHandler)closeHandler, (FlushStrategy)config.tcpConfig().flushStrategy(), (Long)config.tcpConfig().idleTimeoutMs(), (ChannelInitializer)initializer.andThen((ChannelInitializer)new HttpClientChannelInitializer(BufferUtils.getByteBufAllocator((BufferAllocator)executionContext.bufferAllocator()), config.h1Config(), closeHandler)), (ExecutionStrategy)executionContext.executionStrategy(), (ConnectionInfo.Protocol)HttpProtocolVersion.HTTP_1_1, (ConnectionObserver)connectionObserver, (boolean)true), (ConnectionInfo.Protocol)HttpProtocolVersion.HTTP_1_1, channel);
    }
}

