/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.http.api.Http2Exception;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMetaDataFactory;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.netty.AbstractH2DuplexHandler;
import io.servicetalk.http.netty.H2ToStH1ClientDuplexHandler;
import io.servicetalk.http.netty.H2ToStH1Utils;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.NettyH2HeadersToHttpHeaders;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.netty.internal.CloseHandler;
import javax.annotation.Nullable;

final class H2ToStH1ServerDuplexHandler
extends AbstractH2DuplexHandler {
    private boolean readHeaders;
    private boolean responseSent;

    H2ToStH1ServerDuplexHandler(BufferAllocator allocator, HttpHeadersFactory headersFactory, CloseHandler closeHandler, ConnectionObserver.StreamObserver observer) {
        super(allocator, headersFactory, closeHandler, observer);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpResponseMetaData) {
            boolean realResponse;
            HttpResponseMetaData metaData = (HttpResponseMetaData)msg;
            boolean bl = realResponse = !H2ToStH1ClientDuplexHandler.isInterim(metaData.status());
            if (realResponse) {
                this.responseSent = true;
                this.closeHandler.protocolPayloadBeginOutbound(ctx);
            } else if (this.responseSent) {
                return;
            }
            Http2Headers h2Headers = H2ToStH1Utils.h1HeadersToH2Headers(metaData.headers());
            h2Headers.status(metaData.status().codeAsCharSequence());
            this.writeMetaData(ctx, (HttpMetaData)metaData, h2Headers, realResponse, promise);
        } else if (msg instanceof Buffer) {
            H2ToStH1ServerDuplexHandler.writeBuffer(ctx, (Buffer)msg, promise);
        } else if (msg instanceof HttpHeaders) {
            this.writeTrailers(ctx, msg, promise);
        } else {
            ctx.write(msg, promise);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Http2Exception {
        if (msg instanceof Http2HeadersFrame) {
            HttpRequestMethod httpMethod;
            String path;
            Http2HeadersFrame headersFrame = (Http2HeadersFrame)msg;
            int streamId = headersFrame.stream().id();
            Http2Headers h2Headers = headersFrame.headers();
            if (!this.readHeaders) {
                this.closeHandler.protocolPayloadBeginInbound(ctx);
                CharSequence method = (CharSequence)h2Headers.getAndRemove((Object)Http2Headers.PseudoHeaderName.METHOD.value());
                CharSequence pathSequence = (CharSequence)h2Headers.getAndRemove((Object)Http2Headers.PseudoHeaderName.PATH.value());
                if (pathSequence == null) {
                    throw H2ToStH1ServerDuplexHandler.protocolError(ctx, streamId, false, "Incoming request must have '" + Http2Headers.PseudoHeaderName.PATH.value() + "' header");
                }
                if (method == null) {
                    throw H2ToStH1ServerDuplexHandler.protocolError(ctx, streamId, false, "Incoming request must have '" + Http2Headers.PseudoHeaderName.METHOD.value() + "' header");
                }
                path = pathSequence.toString();
                httpMethod = H2ToStH1ServerDuplexHandler.sequenceToHttpRequestMethod(method);
                this.readHeaders = true;
            } else {
                httpMethod = null;
                path = null;
            }
            if (headersFrame.isEndStream()) {
                if (httpMethod != null) {
                    this.fireFullRequest(ctx, h2Headers, httpMethod, path, streamId);
                } else {
                    ctx.fireChannelRead((Object)this.h2TrailersToH1TrailersServer(h2Headers));
                }
                this.closeHandler.protocolPayloadEndInbound(ctx);
            } else {
                if (httpMethod == null) {
                    throw H2ToStH1ServerDuplexHandler.protocolError(ctx, streamId, false, "Incoming request must have '" + Http2Headers.PseudoHeaderName.METHOD.value() + "' header");
                }
                ctx.fireChannelRead((Object)HttpRequestMetaDataFactory.newRequestMetaData((HttpProtocolVersion)HttpProtocolVersion.HTTP_2_0, httpMethod, path, (HttpHeaders)this.h2HeadersToH1HeadersServer(ctx, h2Headers, httpMethod, false, streamId)));
            }
        } else if (msg instanceof Http2DataFrame) {
            this.readDataFrame(ctx, msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void fireFullRequest(ChannelHandlerContext ctx, Http2Headers h2Headers, HttpRequestMethod httpMethod, String path, int streamId) throws Http2Exception {
        ctx.fireChannelRead((Object)HttpRequestMetaDataFactory.newRequestMetaData((HttpProtocolVersion)HttpProtocolVersion.HTTP_2_0, (HttpRequestMethod)httpMethod, (String)path, (HttpHeaders)this.h2HeadersToH1HeadersServer(ctx, h2Headers, httpMethod, true, streamId)));
    }

    private NettyH2HeadersToHttpHeaders h2HeadersToH1HeadersServer(ChannelHandlerContext ctx, Http2Headers h2Headers, @Nullable HttpRequestMethod httpMethod, boolean fullRequest, int streamId) throws Http2Exception {
        CharSequence value = (CharSequence)h2Headers.getAndRemove((Object)Http2Headers.PseudoHeaderName.AUTHORITY.value());
        if (value != null) {
            h2Headers.set((Object)HttpHeaderNames.HOST, (Object)value);
        }
        h2Headers.remove((Object)Http2Headers.PseudoHeaderName.SCHEME.value());
        H2ToStH1Utils.h2HeadersSanitizeForH1(h2Headers);
        if (httpMethod != null) {
            boolean containsContentLength = h2Headers.contains((Object)HttpHeaderNames.CONTENT_LENGTH);
            if (HeaderUtils.clientMaySendPayloadBodyFor(httpMethod)) {
                if (!containsContentLength && fullRequest && HeaderUtils.shouldAddZeroContentLength(httpMethod)) {
                    h2Headers.set((Object)HttpHeaderNames.CONTENT_LENGTH, (Object)HttpHeaderValues.ZERO);
                }
            } else if (containsContentLength) {
                throw H2ToStH1ServerDuplexHandler.protocolError(ctx, streamId, fullRequest, "content-length (" + h2Headers.get((Object)HttpHeaderNames.CONTENT_LENGTH) + ") header is not expected for " + httpMethod.name() + " request");
            }
        }
        return new NettyH2HeadersToHttpHeaders(h2Headers, this.headersFactory.validateCookies(), this.headersFactory.validateValues());
    }

    private NettyH2HeadersToHttpHeaders h2TrailersToH1TrailersServer(Http2Headers h2Headers) {
        return new NettyH2HeadersToHttpHeaders(h2Headers, this.headersFactory.validateCookies(), this.headersFactory.validateValues());
    }

    private static HttpRequestMethod sequenceToHttpRequestMethod(CharSequence sequence) {
        String strMethod = sequence.toString();
        HttpRequestMethod reqMethod = HttpRequestMethod.of((String)strMethod);
        return reqMethod != null ? reqMethod : HttpRequestMethod.of((String)strMethod, (HttpRequestMethod.Properties)HttpRequestMethod.Properties.NONE);
    }
}

