/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.DuplexChannel;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.DefaultHttp2PingFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2PingFrame;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.servicetalk.http.netty.H2KeepAlivePolicies;
import io.servicetalk.http.netty.H2ProtocolConfig;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KeepAliveManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeepAliveManager.class);
    private static final AtomicIntegerFieldUpdater<KeepAliveManager> activeChildChannelsUpdater = AtomicIntegerFieldUpdater.newUpdater(KeepAliveManager.class, "activeChildChannels");
    private static final long GRACEFUL_CLOSE_PING_CONTENT = ThreadLocalRandom.current().nextLong();
    private static final long KEEP_ALIVE_PING_CONTENT = ThreadLocalRandom.current().nextLong();
    private static final Object CLOSED = new Object();
    private static final Object GRACEFUL_CLOSE_START = new Object();
    private static final Object GRACEFUL_CLOSE_SECOND_GO_AWAY_SENT = new Object();
    private static final Object KEEP_ALIVE_ACK_PENDING = new Object();
    private static final Object KEEP_ALIVE_ACK_TIMEDOUT = new Object();
    private volatile int activeChildChannels;
    private final Channel channel;
    private final long pingAckTimeoutNanos;
    private final boolean disallowKeepAliveWithoutActiveStreams;
    private final Scheduler scheduler;
    @Nullable
    private Object gracefulCloseState;
    @Nullable
    private Object keepAliveState;
    @Nullable
    private final GenericFutureListener<Future<? super Void>> pingWriteCompletionListener;

    KeepAliveManager(Channel channel, @Nullable H2ProtocolConfig.KeepAlivePolicy keepAlivePolicy) {
        this(channel, keepAlivePolicy, (task, delay, unit) -> channel.eventLoop().schedule(task, delay, unit), (ch, idlenessThresholdSeconds, onIdle) -> ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(idlenessThresholdSeconds, idlenessThresholdSeconds, 0){

            protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) {
                onIdle.run();
            }
        }}));
    }

    KeepAliveManager(Channel channel, @Nullable H2ProtocolConfig.KeepAlivePolicy keepAlivePolicy, Scheduler scheduler, IdlenessDetector idlenessDetector) {
        if (channel instanceof DuplexChannel) {
            channel.config().setOption(ChannelOption.ALLOW_HALF_CLOSURE, (Object)Boolean.TRUE);
            channel.config().setAutoClose(false);
        }
        this.channel = channel;
        this.scheduler = scheduler;
        if (keepAlivePolicy != null) {
            this.disallowKeepAliveWithoutActiveStreams = !keepAlivePolicy.withoutActiveStreams();
            this.pingAckTimeoutNanos = keepAlivePolicy.ackTimeout().toNanos();
            this.pingWriteCompletionListener = future -> {
                if (future.isSuccess() && this.keepAliveState == KEEP_ALIVE_ACK_PENDING) {
                    this.keepAliveState = scheduler.afterDuration(() -> {
                        if (this.keepAliveState != null) {
                            this.keepAliveState = KEEP_ALIVE_ACK_TIMEDOUT;
                            LOGGER.debug("channel={}, timeout {}ns waiting for keep-alive PING(ACK), writing GO_AWAY.", (Object)this.channel, (Object)this.pingAckTimeoutNanos);
                            channel.writeAndFlush((Object)new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR)).addListener(f -> {
                                if (f.isSuccess()) {
                                    LOGGER.debug("Closing channel={}, after keep-alive timeout.", (Object)this.channel);
                                    this.close0();
                                }
                            });
                        }
                    }, this.pingAckTimeoutNanos, TimeUnit.NANOSECONDS);
                }
            };
            int idleInSeconds = (int)Math.min(keepAlivePolicy.idleDuration().getSeconds(), Integer.MAX_VALUE);
            idlenessDetector.configure(channel, idleInSeconds, this::channelIdle);
        } else {
            this.disallowKeepAliveWithoutActiveStreams = false;
            this.pingAckTimeoutNanos = H2KeepAlivePolicies.DEFAULT_ACK_TIMEOUT.toNanos();
            this.pingWriteCompletionListener = null;
        }
    }

    void pingReceived(Http2PingFrame pingFrame) {
        assert (this.channel.eventLoop().inEventLoop());
        if (pingFrame.ack()) {
            long pingAckContent = pingFrame.content();
            if (pingAckContent == GRACEFUL_CLOSE_PING_CONTENT) {
                LOGGER.debug("channel={}, graceful close ping ack received.", (Object)this.channel);
                this.cancelIfStateIsAFuture(this.gracefulCloseState);
                this.gracefulCloseWriteSecondGoAway();
            } else if (pingAckContent == KEEP_ALIVE_PING_CONTENT) {
                this.cancelIfStateIsAFuture(this.keepAliveState);
                this.keepAliveState = null;
            }
        } else {
            this.channel.writeAndFlush((Object)new DefaultHttp2PingFrame(pingFrame.content(), true));
        }
    }

    void trackActiveStream(Channel streamChannel) {
        activeChildChannelsUpdater.incrementAndGet(this);
        streamChannel.closeFuture().addListener(f -> {
            if (activeChildChannelsUpdater.decrementAndGet(this) == 0 && this.gracefulCloseState == GRACEFUL_CLOSE_SECOND_GO_AWAY_SENT) {
                this.close0();
            }
        });
    }

    void channelClosed() {
        assert (this.channel.eventLoop().inEventLoop());
        this.cancelIfStateIsAFuture(this.gracefulCloseState);
        this.cancelIfStateIsAFuture(this.keepAliveState);
        this.gracefulCloseState = CLOSED;
        this.keepAliveState = CLOSED;
    }

    void initiateGracefulClose(Runnable whenInitiated) {
        EventLoop eventLoop = this.channel.eventLoop();
        if (eventLoop.inEventLoop()) {
            this.doCloseAsyncGracefully0(whenInitiated);
        } else {
            eventLoop.execute(() -> this.doCloseAsyncGracefully0(whenInitiated));
        }
    }

    void channelIdle() {
        assert (this.channel.eventLoop().inEventLoop());
        assert (this.pingWriteCompletionListener != null);
        if (this.keepAliveState != null || this.disallowKeepAliveWithoutActiveStreams && this.activeChildChannels == 0) {
            return;
        }
        this.keepAliveState = KEEP_ALIVE_ACK_PENDING;
        this.channel.writeAndFlush((Object)new DefaultHttp2PingFrame(KEEP_ALIVE_PING_CONTENT, false)).addListener(this.pingWriteCompletionListener);
    }

    void channelOutputShutdown() {
        assert (this.channel.eventLoop().inEventLoop());
        this.channelHalfShutdown(DuplexChannel::isInputShutdown);
    }

    void channelInputShutdown() {
        assert (this.channel.eventLoop().inEventLoop());
        this.channelHalfShutdown(DuplexChannel::isOutputShutdown);
    }

    private void channelHalfShutdown(Predicate<DuplexChannel> otherSideShutdown) {
        if (this.channel instanceof DuplexChannel) {
            DuplexChannel duplexChannel = (DuplexChannel)this.channel;
            if (otherSideShutdown.test(duplexChannel) || this.gracefulCloseState != GRACEFUL_CLOSE_SECOND_GO_AWAY_SENT && this.gracefulCloseState != CLOSED) {
                duplexChannel.close();
            }
        } else {
            this.channel.close();
        }
    }

    private void doCloseAsyncGracefully0(Runnable whenInitiated) {
        assert (this.channel.eventLoop().inEventLoop());
        if (this.gracefulCloseState != null) {
            return;
        }
        whenInitiated.run();
        this.gracefulCloseState = GRACEFUL_CLOSE_START;
        DefaultHttp2GoAwayFrame goAwayFrame = new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR);
        goAwayFrame.setExtraStreamIds(Integer.MAX_VALUE);
        this.channel.write((Object)goAwayFrame);
        this.channel.writeAndFlush((Object)new DefaultHttp2PingFrame(GRACEFUL_CLOSE_PING_CONTENT)).addListener(future -> {
            if (future.isSuccess() && this.gracefulCloseState == GRACEFUL_CLOSE_START) {
                this.gracefulCloseState = this.scheduler.afterDuration(() -> {
                    LOGGER.debug("channel={} timeout {}ns waiting for PING(ACK) during graceful close.", (Object)this.channel, (Object)this.pingAckTimeoutNanos);
                    this.gracefulCloseWriteSecondGoAway();
                }, this.pingAckTimeoutNanos, TimeUnit.NANOSECONDS);
            }
        });
    }

    private void gracefulCloseWriteSecondGoAway() {
        assert (this.channel.eventLoop().inEventLoop());
        if (this.gracefulCloseState == GRACEFUL_CLOSE_SECOND_GO_AWAY_SENT) {
            return;
        }
        this.gracefulCloseState = GRACEFUL_CLOSE_SECOND_GO_AWAY_SENT;
        this.channel.writeAndFlush((Object)new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR)).addListener(future -> {
            if (this.activeChildChannels == 0) {
                this.close0();
            }
        });
    }

    private void close0() {
        assert (this.channel.eventLoop().inEventLoop());
        if (this.gracefulCloseState == CLOSED && this.keepAliveState == CLOSED) {
            return;
        }
        this.gracefulCloseState = CLOSED;
        this.keepAliveState = CLOSED;
        this.channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener(f -> {
            SslHandler sslHandler = (SslHandler)this.channel.pipeline().get(SslHandler.class);
            if (sslHandler != null) {
                sslHandler.closeOutbound().addListener(f2 -> this.doShutdownOutput());
            } else {
                this.doShutdownOutput();
            }
        });
    }

    private void doShutdownOutput() {
        if (this.channel instanceof DuplexChannel) {
            DuplexChannel duplexChannel = (DuplexChannel)this.channel;
            duplexChannel.shutdownOutput().addListener(f -> {
                if (duplexChannel.isInputShutdown()) {
                    this.channel.close();
                }
            });
        } else {
            this.channel.close();
        }
    }

    private void cancelIfStateIsAFuture(@Nullable Object state) {
        if (state instanceof Future) {
            try {
                ((Future)state).cancel(true);
            }
            catch (Throwable t) {
                LOGGER.debug("Failed to cancel {} scheduled future.", (Object)(state == this.keepAliveState ? "keep-alive" : "graceful close"), (Object)t);
            }
        }
    }

    @FunctionalInterface
    static interface IdlenessDetector {
        public void configure(Channel var1, int var2, Runnable var3);
    }

    @FunctionalInterface
    static interface Scheduler {
        public Future<?> afterDuration(Runnable var1, long var2, TimeUnit var4);
    }
}

