/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey.internal;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.router.jersey.internal.BufferPublisherInputStream;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.GenericType;

public final class RequestProperties {
    private static final String REQUEST_BUFFER_PUBLISHER_IS = new GenericType<BufferPublisherInputStream>(){}.getType().getTypeName();
    private static final String REQUEST_CANCELLABLE = new GenericType<DelayedCancellable>(){}.getType().getTypeName();
    private static final String RESPONSE_BUFFER_PUBLISHER = new GenericType<Publisher<Buffer>>(){}.getType().getTypeName();
    private static final String RESPONSE_EXEC_STRATEGY = new GenericType<HttpExecutionStrategy>(){}.getType().getTypeName();

    private RequestProperties() {
    }

    public static void initRequestProperties(BufferPublisherInputStream entityStream, ContainerRequestContext reqCtx) {
        reqCtx.setProperty(REQUEST_BUFFER_PUBLISHER_IS, (Object)Objects.requireNonNull(entityStream));
        reqCtx.setProperty(REQUEST_CANCELLABLE, (Object)new DelayedCancellable());
        reqCtx.setProperty(RESPONSE_BUFFER_PUBLISHER, null);
        reqCtx.setProperty(RESPONSE_EXEC_STRATEGY, null);
    }

    public static BufferPublisherInputStream getRequestBufferPublisherInputStream(ContainerRequestContext reqCtx) {
        return (BufferPublisherInputStream)reqCtx.getProperty(REQUEST_BUFFER_PUBLISHER_IS);
    }

    public static Cancellable getRequestCancellable(ContainerRequestContext reqCtx) {
        return (DelayedCancellable)reqCtx.getProperty(REQUEST_CANCELLABLE);
    }

    public static void setRequestCancellable(Cancellable cancellable, ContainerRequestContext reqCtx) {
        ((DelayedCancellable)reqCtx.getProperty(REQUEST_CANCELLABLE)).delayedCancellable(Objects.requireNonNull(cancellable));
    }

    @Nullable
    public static Publisher<Buffer> getResponseBufferPublisher(ContainerRequestContext reqCtx) {
        return (Publisher)reqCtx.getProperty(RESPONSE_BUFFER_PUBLISHER);
    }

    public static void setResponseBufferPublisher(Publisher<Buffer> bufferPublisher, ContainerRequestContext reqCtx) {
        reqCtx.setProperty(RESPONSE_BUFFER_PUBLISHER, Objects.requireNonNull(bufferPublisher));
    }

    @Nullable
    public static HttpExecutionStrategy getResponseExecutionStrategy(ContainerRequestContext reqCtx) {
        return (HttpExecutionStrategy)reqCtx.getProperty(RESPONSE_EXEC_STRATEGY);
    }

    public static void setResponseExecutionStrategy(HttpExecutionStrategy executor, ContainerRequestContext reqCtx) {
        reqCtx.setProperty(RESPONSE_EXEC_STRATEGY, (Object)executor);
    }
}

