/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.internal.SubscribableSingle;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.http.api.HttpContextKeys;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.RedirectConfig;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestFactory;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.transport.api.HostAndPort;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RedirectSingle
extends SubscribableSingle<StreamingHttpResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedirectSingle.class);
    private final SingleSource<StreamingHttpResponse> originalResponse;
    private final StreamingHttpRequest originalRequest;
    private final StreamingHttpRequester requester;
    private final boolean allowNonRelativeRedirects;
    private final RedirectConfig config;

    RedirectSingle(StreamingHttpRequester requester, StreamingHttpRequest originalRequest, Single<StreamingHttpResponse> originalResponse, boolean allowNonRelativeRedirects, RedirectConfig config) {
        this.requester = requester;
        this.originalRequest = originalRequest;
        this.originalResponse = SourceAdapters.toSource(originalResponse);
        this.allowNonRelativeRedirects = allowNonRelativeRedirects;
        this.config = config;
    }

    protected void handleSubscribe(SingleSource.Subscriber<? super StreamingHttpResponse> subscriber) {
        this.originalResponse.subscribe((SingleSource.Subscriber)new RedirectSubscriber(subscriber, this, this.originalRequest));
    }

    private static final class RedirectSubscriber
    implements SingleSource.Subscriber<StreamingHttpResponse> {
        private final SingleSource.Subscriber<? super StreamingHttpResponse> target;
        private final RedirectSingle redirectSingle;
        private final StreamingHttpRequest request;
        @Nullable
        private final String scheme;
        private final int redirectCount;
        private final SequentialCancellable sequentialCancellable;

        RedirectSubscriber(SingleSource.Subscriber<? super StreamingHttpResponse> target, RedirectSingle redirectSingle, StreamingHttpRequest request) {
            this(target, redirectSingle, request, 0, new SequentialCancellable());
        }

        RedirectSubscriber(SingleSource.Subscriber<? super StreamingHttpResponse> target, RedirectSingle redirectSingle, StreamingHttpRequest request, int redirectCount, SequentialCancellable sequentialCancellable) {
            this.target = target;
            this.redirectSingle = redirectSingle;
            this.request = request;
            this.scheme = request.scheme();
            this.redirectCount = redirectCount;
            this.sequentialCancellable = sequentialCancellable;
        }

        public void onSubscribe(Cancellable cancellable) {
            this.sequentialCancellable.nextCancellable(cancellable);
            if (this.redirectCount == 0) {
                this.target.onSubscribe((Cancellable)this.sequentialCancellable);
            }
        }

        public void onSuccess(@Nullable StreamingHttpResponse response) {
            if (response == null) {
                this.target.onSuccess(null);
                return;
            }
            boolean terminalDelivered = false;
            try {
                String location = this.redirectLocation(this.redirectCount, (HttpRequestMetaData)this.request, (HttpResponseMetaData)response);
                if (location == null) {
                    terminalDelivered = true;
                    this.target.onSuccess((Object)response);
                    return;
                }
                StreamingHttpRequest newRequest = this.prepareRedirectRequest(this.request, (StreamingHttpRequestFactory)this.redirectSingle.requester, location);
                if (newRequest == null) {
                    terminalDelivered = true;
                    this.target.onSuccess((Object)response);
                    return;
                }
                String newScheme = newRequest.scheme();
                boolean relative = RedirectSubscriber.isRelative((HttpRequestMetaData)this.request, this.scheme, (HttpRequestMetaData)newRequest);
                if (!relative && !this.redirectSingle.allowNonRelativeRedirects) {
                    LOGGER.debug("Ignoring non-relative redirect to '{}' for request '{}': Only relative redirects are allowed", (Object)newRequest.requestTarget(), (Object)this.request);
                    terminalDelivered = true;
                    this.target.onSuccess((Object)response);
                    return;
                }
                if (!this.redirectSingle.config.redirectPredicate().test(relative, this.redirectCount, (HttpRequestMetaData)this.request, (HttpResponseMetaData)response)) {
                    terminalDelivered = true;
                    this.target.onSuccess((Object)response);
                    return;
                }
                if (relative) {
                    if (this.redirectSingle.allowNonRelativeRedirects && newScheme == null && this.scheme != null) {
                        newRequest.requestTarget(this.scheme + "://" + newRequest.headers().get(HttpHeaderNames.HOST) + newRequest.requestTarget());
                    }
                    if (!this.redirectSingle.allowNonRelativeRedirects && newScheme != null) {
                        newRequest.requestTarget(RedirectSubscriber.absoluteToRelativeFormRequestTarget(newRequest.requestTarget(), newScheme));
                    }
                }
                newRequest = this.redirectSingle.config.redirectRequestTransformer().apply(relative, this.request, response, newRequest);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Executing redirect to '{}' for request '{}'", (Object)location, (Object)this.request);
                }
                terminalDelivered = true;
                SourceAdapters.toSource((Single)response.messageBody().ignoreElements().concat(this.redirectSingle.requester.request(newRequest))).subscribe((SingleSource.Subscriber)new RedirectSubscriber(this.target, this.redirectSingle, newRequest, this.redirectCount + 1, this.sequentialCancellable));
            }
            catch (Throwable cause) {
                if (!terminalDelivered) {
                    SubscriberUtils.safeOnError(this.target, (Throwable)cause);
                }
                LOGGER.info("Ignoring exception from onSuccess of Subscriber {}.", this.target, (Object)cause);
            }
        }

        private static String absoluteToRelativeFormRequestTarget(String requestTarget, String scheme) {
            int fromIndex = scheme.length() + 3;
            int relativeReferenceIdx = requestTarget.indexOf(47, fromIndex);
            if (relativeReferenceIdx >= 0) {
                return requestTarget.substring(relativeReferenceIdx);
            }
            int questionMarkIdx = requestTarget.indexOf(63, fromIndex);
            return questionMarkIdx < 0 ? "/" : '/' + requestTarget.substring(questionMarkIdx);
        }

        public void onError(Throwable t) {
            this.target.onError(t);
        }

        @Nullable
        private String redirectLocation(int redirectCount, HttpRequestMetaData requestMetaData, HttpResponseMetaData responseMetaData) {
            HttpResponseStatus status = responseMetaData.status();
            if (!HttpResponseStatus.StatusClass.REDIRECTION_3XX.contains(status)) {
                return null;
            }
            RedirectConfig config = this.redirectSingle.config;
            if (redirectCount >= config.maxRedirects()) {
                LOGGER.debug("Maximum number of redirects ({}) reached for original request: {}", (Object)config.maxRedirects(), (Object)this.redirectSingle.originalRequest);
                return null;
            }
            if (!config.allowedStatuses().contains(status)) {
                LOGGER.debug("Configuration does not allow redirect for response status: {}", (Object)status);
                return null;
            }
            HttpRequestMethod requestMethod = requestMetaData.method();
            if (!config.allowedMethods().contains(requestMethod)) {
                LOGGER.debug("Configuration does not allow redirect for request method: {}", (Object)requestMethod);
                return null;
            }
            String location = (String)config.locationMapper().apply(requestMetaData, responseMetaData);
            if (location == null) {
                LOGGER.debug("No location identified for redirect response: {}", (Object)responseMetaData);
            }
            return location;
        }

        @Nullable
        private StreamingHttpRequest prepareRedirectRequest(StreamingHttpRequest request, StreamingHttpRequestFactory requestFactory, String redirectLocation) {
            HttpExecutionStrategy strategy;
            StreamingHttpRequest redirectRequest = requestFactory.newRequest(request.method(), redirectLocation).version(request.version());
            String redirectHost = redirectRequest.host();
            if (redirectHost == null && this.redirectSingle.allowNonRelativeRedirects) {
                HostAndPort requestHostAndPort = request.effectiveHostAndPort();
                if (requestHostAndPort == null) {
                    return null;
                }
                int redirectPort = requestHostAndPort.port();
                redirectRequest.setHeader(HttpHeaderNames.HOST, (CharSequence)(redirectPort < 0 ? requestHostAndPort.hostName() : requestHostAndPort.hostName() + ':' + redirectPort));
            }
            if ((strategy = (HttpExecutionStrategy)request.context().get(HttpContextKeys.HTTP_EXECUTION_STRATEGY_KEY)) != null) {
                redirectRequest.context().put(HttpContextKeys.HTTP_EXECUTION_STRATEGY_KEY, (Object)strategy);
            }
            return redirectRequest;
        }

        private static boolean isRelative(HttpRequestMetaData originalRequest, @Nullable String originalScheme, HttpRequestMetaData redirectRequest) {
            String toHost = redirectRequest.host();
            if (toHost == null) {
                return true;
            }
            HostAndPort original = originalRequest.effectiveHostAndPort();
            if (original == null) {
                return false;
            }
            if (!toHost.equalsIgnoreCase(original.hostName())) {
                return false;
            }
            return RedirectSubscriber.inferPort(redirectRequest.port(), redirectRequest.scheme(), original.port()) == RedirectSubscriber.inferPort(original.port(), originalScheme, original.port());
        }

        private static int inferPort(int parsedPort, @Nullable String scheme, int fallbackPort) {
            if (parsedPort >= 0) {
                return parsedPort;
            }
            if (scheme == null) {
                return fallbackPort;
            }
            return "https".equalsIgnoreCase(scheme) ? 443 : 80;
        }
    }
}

