/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.api;

import io.servicetalk.transport.api.HostAndPort;
import java.util.Objects;

final class DefaultHostAndPort
implements HostAndPort {
    private final String hostName;
    private final int port;

    DefaultHostAndPort(String hostName, int port) {
        this.hostName = Objects.requireNonNull(hostName);
        this.port = port;
    }

    @Override
    public String hostName() {
        return this.hostName;
    }

    @Override
    public int port() {
        return this.port;
    }

    public String toString() {
        return this.hostName + ':' + this.port;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultHostAndPort)) {
            return false;
        }
        DefaultHostAndPort rhs = (DefaultHostAndPort)o;
        return this.port == rhs.port() && this.hostName.equals(rhs.hostName());
    }

    public int hashCode() {
        return 31 * (31 + this.port) + this.hostName.hashCode();
    }
}

