/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import javax.annotation.Nullable;

public final class ChannelCloseUtils {
    private static final AttributeKey<Throwable> CONNECTION_ERROR = AttributeKey.newInstance((String)"ConnectionError");

    private ChannelCloseUtils() {
    }

    public static void assignConnectionError(Channel channel, Throwable error) {
        channel.attr(CONNECTION_ERROR).setIfAbsent((Object)error);
    }

    public static ChannelFuture close(Channel channel, Throwable error) {
        channel.attr(CONNECTION_ERROR).setIfAbsent((Object)error);
        return channel.close();
    }

    public static ChannelFuture close(ChannelHandlerContext ctx, Throwable error) {
        ctx.channel().attr(CONNECTION_ERROR).setIfAbsent((Object)error);
        return ctx.close();
    }

    @Nullable
    public static Throwable channelError(Channel channel) {
        return (Throwable)channel.attr(CONNECTION_ERROR).getAndSet(null);
    }
}

