/*
 * Decompiled with CFR 0.152.
 */
package io.seventytwo.vaadinjooq.ui;

import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.ConfigurableFilterDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.provider.SortOrder;
import com.vaadin.flow.function.ValueProvider;
import io.seventytwo.vaadinjooq.repository.JooqRepository;
import io.seventytwo.vaadinjooq.util.JooqUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;

public class RecordGrid<R extends Record>
extends Grid<R> {
    private ConfigurableFilterDataProvider<R, Void, Condition> filterDataProvider;

    private RecordGrid() {
    }

    private void createColumns(TableField<?, ?>[] columns, String[] headers) {
        if (headers != null && headers.length != columns.length) {
            throw new IllegalStateException("Number of headers must match number of cloumns!");
        }
        for (int i = 0; i < columns.length; ++i) {
            TableField<?, ?> column = columns[i];
            String header = headers != null ? headers[i] : JooqUtil.getHeaderText(column);
            this.addColumn((ValueProvider & Serializable)r -> r.getValue((Field)column)).setHeader(header).setKey(column.getName()).setSortProperty(new String[]{column.getName()}).setSortable(true);
        }
    }

    private void setFilterDataProvider(ConfigurableFilterDataProvider<R, Void, Condition> filterDataProvider) {
        this.filterDataProvider = filterDataProvider;
        super.setItems(filterDataProvider);
    }

    public void filter(Condition condition) {
        this.filterDataProvider.setFilter((Object)condition);
        this.filterDataProvider.refreshAll();
    }

    public void refreshAll() {
        this.filterDataProvider.refreshAll();
    }

    public void refreshItem(R item) {
        this.filterDataProvider.refreshItem(item);
    }

    public static class Builder<R extends Record> {
        private final JooqRepository repository;
        private final Table<R> table;
        private RecordGrid<R> grid;
        private TableField<?, ?>[] columns;
        private TableField<?, ?>[] idColumns;
        private String[] headers;
        private Condition condition;
        private Map<Field<?>, SortDirection> sort;

        public Builder(Table<R> table, DSLContext dslContext) {
            this.table = table;
            this.repository = new JooqRepository(dslContext);
        }

        public Builder<R> withColumns(TableField<?, ?> ... columns) {
            this.columns = columns;
            return this;
        }

        public Builder<R> withHeaders(String ... headers) {
            this.headers = headers;
            return this;
        }

        public Builder<R> withIdColumns(TableField<?, ?> ... idColumns) {
            this.idColumns = idColumns;
            return this;
        }

        public Builder<R> withCondition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public Builder<R> withSort(Map<Field<?>, SortDirection> sort) {
            this.sort = sort;
            return this;
        }

        public RecordGrid<R> build() {
            this.grid = new RecordGrid();
            if (this.columns != null && this.columns.length > 0) {
                this.grid.createColumns(this.columns, this.headers);
            }
            if (this.table.getPrimaryKey() == null && (this.idColumns == null || this.idColumns.length == 0)) {
                throw new IllegalStateException("The table has no primary key or unique key and no idColumns are provided!");
            }
            this.grid.setFilterDataProvider(this.createDataProvider());
            return this.grid;
        }

        private ConfigurableFilterDataProvider<R, Void, Condition> createDataProvider() {
            CallbackDataProvider dataProvider = new CallbackDataProvider((CallbackDataProvider.FetchCallback & Serializable)query -> {
                List rows = this.repository.findAll(this.table, this.createFilter(query), this.createOrderBy(query), query.getOffset(), query.getLimit());
                if (!rows.isEmpty() && this.grid.getSelectedItems().isEmpty()) {
                    this.grid.select((Record)rows.get(0));
                }
                return rows.stream();
            }, (CallbackDataProvider.CountCallback & Serializable)query -> this.repository.count(this.table, this.createFilter(query)), (ValueProvider & Serializable)r -> {
                StringBuilder sb;
                block4: {
                    block5: {
                        block3: {
                            sb = new StringBuilder();
                            if (this.idColumns == null || this.idColumns.length <= 0) break block3;
                            for (TableField<?, ?> idColumn : this.idColumns) {
                                Object value = r.getValue(idColumn);
                                sb.append(value);
                            }
                            break block4;
                        }
                        UniqueKey primaryKey = this.table.getPrimaryKey();
                        if (primaryKey == null) break block5;
                        for (TableField field : primaryKey.getFields()) {
                            Object value = r.getValue((Field)field);
                            sb.append(value);
                        }
                        break block4;
                    }
                    if (this.table.getUniqueKeys().isEmpty()) break block4;
                    UniqueKey uniqueKey = (UniqueKey)this.table.getUniqueKeys().get(0);
                    for (TableField field : uniqueKey.getFields()) {
                        Object value = r.getValue((Field)field);
                        sb.append(value);
                    }
                }
                return sb.toString();
            });
            return dataProvider.withConfigurableFilter();
        }

        private Condition createFilter(Query<R, Condition> query) {
            Optional filter = query.getFilter();
            Condition filterCondition = filter.isPresent() ? (this.condition == null ? (Condition)filter.get() : this.condition.and((Condition)filter.get())) : this.condition;
            return filterCondition;
        }

        private Map<Field<?>, SortDirection> createOrderBy(Query<R, Condition> query) {
            Map<Field<?>, SortDirection> orderBy = new HashMap();
            for (SortOrder sortOrder : query.getSortOrders()) {
                orderBy.put(this.table.field((String)sortOrder.getSorted()), sortOrder.getDirection());
            }
            if (orderBy.isEmpty()) {
                orderBy = this.sort;
            }
            return orderBy;
        }
    }
}

