/*
 * Decompiled with CFR 0.152.
 */
package io.seventytwo.vaadinjooq.util;

import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.SortDirection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.impl.DSL;

public class VaadinJooqUtil {
    private VaadinJooqUtil() {
    }

    public static List<OrderField<?>> orderFields(Table<?> table, Query<?, ?> query) {
        ArrayList orderFields = new ArrayList();
        for (QuerySortOrder sortOrder : query.getSortOrders()) {
            Field field = table.field((String)sortOrder.getSorted());
            if (field == null) {
                throw new IllegalArgumentException(MessageFormat.format("Field {0} is not a field of {1}", table.getName(), sortOrder.getSorted()));
            }
            orderFields.add((OrderField<?>)(sortOrder.getDirection().equals((Object)SortDirection.DESCENDING) ? field.desc() : field));
        }
        return orderFields;
    }

    public static List<? extends OrderField<?>> createSortOrder(Class<?> recordType, Query<?, ?> query) {
        return query.getSortOrders().stream().map(querySortOrder -> VaadinJooqUtil.mapFieldsOrThrowException(recordType, querySortOrder)).collect(Collectors.toList());
    }

    private static SortField<?> mapFieldsOrThrowException(Class<?> recordType, QuerySortOrder querySortOrder) {
        Arrays.stream(recordType.getRecordComponents()).filter(recordComponent -> !((String)querySortOrder.getSorted()).equalsIgnoreCase(recordComponent.getName())).findAny().orElseThrow(() -> new IllegalArgumentException(MessageFormat.format("Field {0} is not a field of {1}", querySortOrder.getSorted(), recordType.getName())));
        return querySortOrder.getDirection() == SortDirection.ASCENDING ? DSL.field((String)((String)querySortOrder.getSorted())).asc() : DSL.field((String)((String)querySortOrder.getSorted())).desc();
    }
}

