/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.api.config.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.shardingjdbc.core.api.algorithm.sharding.standard.PreciseShardingAlgorithm;
import io.shardingjdbc.core.api.algorithm.sharding.standard.RangeShardingAlgorithm;
import io.shardingjdbc.core.api.config.strategy.ShardingStrategyConfiguration;
import io.shardingjdbc.core.routing.strategy.ShardingAlgorithmFactory;
import io.shardingjdbc.core.routing.strategy.ShardingStrategy;
import io.shardingjdbc.core.routing.strategy.standard.StandardShardingStrategy;
import java.beans.ConstructorProperties;

public final class StandardShardingStrategyConfiguration
implements ShardingStrategyConfiguration {
    private final String shardingColumn;
    private final String preciseAlgorithmClassName;
    private final String rangeAlgorithmClassName;

    public StandardShardingStrategyConfiguration(String shardingColumn, String preciseAlgorithmClassName) {
        this(shardingColumn, preciseAlgorithmClassName, null);
    }

    @Override
    public ShardingStrategy build() {
        Preconditions.checkNotNull((Object)this.shardingColumn, (Object)"Sharding column cannot be null.");
        Preconditions.checkNotNull((Object)this.preciseAlgorithmClassName, (Object)"Precise algorithm class cannot be null.");
        if (Strings.isNullOrEmpty((String)this.rangeAlgorithmClassName)) {
            return new StandardShardingStrategy(this.shardingColumn, ShardingAlgorithmFactory.newInstance(this.preciseAlgorithmClassName, PreciseShardingAlgorithm.class));
        }
        return new StandardShardingStrategy(this.shardingColumn, ShardingAlgorithmFactory.newInstance(this.preciseAlgorithmClassName, PreciseShardingAlgorithm.class), ShardingAlgorithmFactory.newInstance(this.rangeAlgorithmClassName, RangeShardingAlgorithm.class));
    }

    @ConstructorProperties(value={"shardingColumn", "preciseAlgorithmClassName", "rangeAlgorithmClassName"})
    public StandardShardingStrategyConfiguration(String shardingColumn, String preciseAlgorithmClassName, String rangeAlgorithmClassName) {
        this.shardingColumn = shardingColumn;
        this.preciseAlgorithmClassName = preciseAlgorithmClassName;
        this.rangeAlgorithmClassName = rangeAlgorithmClassName;
    }

    public String getShardingColumn() {
        return this.shardingColumn;
    }

    public String getPreciseAlgorithmClassName() {
        return this.preciseAlgorithmClassName;
    }

    public String getRangeAlgorithmClassName() {
        return this.rangeAlgorithmClassName;
    }
}

