/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.jdbc.core.datasource;

import io.shardingjdbc.core.api.ConfigMapContext;
import io.shardingjdbc.core.constant.ShardingProperties;
import io.shardingjdbc.core.constant.ShardingPropertiesConstant;
import io.shardingjdbc.core.executor.ExecutorEngine;
import io.shardingjdbc.core.jdbc.adapter.AbstractDataSourceAdapter;
import io.shardingjdbc.core.jdbc.core.ShardingContext;
import io.shardingjdbc.core.jdbc.core.connection.ShardingConnection;
import io.shardingjdbc.core.rule.ShardingRule;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class ShardingDataSource
extends AbstractDataSourceAdapter
implements AutoCloseable {
    private ShardingProperties shardingProperties;
    private ExecutorEngine executorEngine;
    private ShardingContext shardingContext;

    public ShardingDataSource(ShardingRule shardingRule) throws SQLException {
        this(shardingRule, new ConcurrentHashMap<String, Object>(), new Properties());
    }

    public ShardingDataSource(ShardingRule shardingRule, Map<String, Object> configMap, Properties props) throws SQLException {
        super(shardingRule.getDataSourceMap().values());
        if (!configMap.isEmpty()) {
            ConfigMapContext.getInstance().getShardingConfig().putAll(configMap);
        }
        this.shardingProperties = new ShardingProperties(null == props ? new Properties() : props);
        int executorSize = (Integer)this.shardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_SIZE);
        this.executorEngine = new ExecutorEngine(executorSize);
        boolean showSQL = (Boolean)this.shardingProperties.getValue(ShardingPropertiesConstant.SQL_SHOW);
        this.shardingContext = new ShardingContext(shardingRule, this.getDatabaseType(), this.executorEngine, showSQL);
    }

    public void renew(ShardingRule newShardingRule, Properties newProps) throws SQLException {
        int newExecutorSize;
        ShardingProperties newShardingProperties = new ShardingProperties(null == newProps ? new Properties() : newProps);
        int originalExecutorSize = (Integer)this.shardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_SIZE);
        if (originalExecutorSize != (newExecutorSize = ((Integer)newShardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_SIZE)).intValue())) {
            this.executorEngine.close();
            this.executorEngine = new ExecutorEngine(newExecutorSize);
        }
        boolean newShowSQL = (Boolean)newShardingProperties.getValue(ShardingPropertiesConstant.SQL_SHOW);
        this.shardingProperties = newShardingProperties;
        this.shardingContext = new ShardingContext(newShardingRule, this.getDatabaseType(), this.executorEngine, newShowSQL);
    }

    @Override
    public ShardingConnection getConnection() throws SQLException {
        return new ShardingConnection(this.shardingContext);
    }

    @Override
    public void close() {
        this.executorEngine.close();
    }
}

