/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.merger.common;

import io.shardingjdbc.core.merger.ResultSetMerger;
import io.shardingjdbc.core.merger.common.MemoryResultSetRow;
import io.shardingjdbc.core.util.SQLUtil;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.util.Calendar;
import java.util.Map;

public abstract class AbstractMemoryResultSetMerger
implements ResultSetMerger {
    private final Map<String, Integer> labelAndIndexMap;
    private MemoryResultSetRow currentResultSetRow;
    private boolean wasNull;

    @Override
    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (Blob.class == type || Clob.class == type || Reader.class == type || InputStream.class == type || SQLXML.class == type) {
            throw new SQLFeatureNotSupportedException();
        }
        Object result = this.currentResultSetRow.getCell(columnIndex);
        this.wasNull = null == result;
        return result;
    }

    @Override
    public Object getValue(String columnLabel, Class<?> type) throws SQLException {
        if (Blob.class == type || Clob.class == type || Reader.class == type || InputStream.class == type || SQLXML.class == type) {
            throw new SQLFeatureNotSupportedException();
        }
        Object result = this.currentResultSetRow.getCell(this.labelAndIndexMap.containsKey(columnLabel) ? this.labelAndIndexMap.get(columnLabel) : this.labelAndIndexMap.get(SQLUtil.getExactlyValue(columnLabel)));
        this.wasNull = null == result;
        return result;
    }

    @Override
    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        Object result = this.currentResultSetRow.getCell(columnIndex);
        this.wasNull = null == result;
        return result;
    }

    @Override
    public Object getCalendarValue(String columnLabel, Class<?> type, Calendar calendar) throws SQLException {
        Object result = this.currentResultSetRow.getCell(this.labelAndIndexMap.get(columnLabel));
        this.wasNull = null == result;
        return result;
    }

    @Override
    public InputStream getInputStream(int columnIndex, String type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getInputStream(String columnLabel, String type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @ConstructorProperties(value={"labelAndIndexMap"})
    public AbstractMemoryResultSetMerger(Map<String, Integer> labelAndIndexMap) {
        this.labelAndIndexMap = labelAndIndexMap;
    }

    public void setCurrentResultSetRow(MemoryResultSetRow currentResultSetRow) {
        this.currentResultSetRow = currentResultSetRow;
    }
}

