/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.clause;

import io.shardingjdbc.core.exception.ShardingJdbcException;
import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.lexer.token.DefaultKeyword;
import io.shardingjdbc.core.parsing.lexer.token.Keyword;
import io.shardingjdbc.core.parsing.lexer.token.Symbol;
import io.shardingjdbc.core.parsing.parser.clause.SQLClauseParser;
import io.shardingjdbc.core.parsing.parser.clause.expression.BasicExpressionParser;
import io.shardingjdbc.core.parsing.parser.context.GeneratedKey;
import io.shardingjdbc.core.parsing.parser.context.condition.Column;
import io.shardingjdbc.core.parsing.parser.context.condition.Condition;
import io.shardingjdbc.core.parsing.parser.context.condition.Conditions;
import io.shardingjdbc.core.parsing.parser.dialect.ExpressionParserFactory;
import io.shardingjdbc.core.parsing.parser.expression.SQLExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLNumberExpression;
import io.shardingjdbc.core.parsing.parser.expression.SQLPlaceholderExpression;
import io.shardingjdbc.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingjdbc.core.parsing.parser.token.MultipleInsertValuesToken;
import io.shardingjdbc.core.rule.ShardingRule;
import java.util.Arrays;
import java.util.LinkedList;

public class InsertValuesClauseParser
implements SQLClauseParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final BasicExpressionParser basicExpressionParser;

    public InsertValuesClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public void parse(InsertStatement insertStatement) {
        LinkedList<Keyword> valueKeywords = new LinkedList<Keyword>();
        valueKeywords.add(DefaultKeyword.VALUES);
        valueKeywords.addAll(Arrays.asList(this.getSynonymousKeywordsForValues()));
        if (this.lexerEngine.skipIfEqual(valueKeywords.toArray(new Keyword[valueKeywords.size()]))) {
            insertStatement.setAfterValuesPosition(this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length());
            this.parseValues(insertStatement);
            if (this.lexerEngine.equalAny(Symbol.COMMA)) {
                this.parseMultipleValues(insertStatement);
            }
        }
    }

    protected Keyword[] getSynonymousKeywordsForValues() {
        return new Keyword[0];
    }

    private void parseValues(InsertStatement insertStatement) {
        this.lexerEngine.accept(Symbol.LEFT_PAREN);
        LinkedList<SQLExpression> sqlExpressions = new LinkedList<SQLExpression>();
        do {
            sqlExpressions.add(this.basicExpressionParser.parse(insertStatement));
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
        insertStatement.setValuesListLastPosition(this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length());
        int count = 0;
        for (Column each : insertStatement.getColumns()) {
            SQLExpression sqlExpression = (SQLExpression)sqlExpressions.get(count);
            insertStatement.getConditions().add(new Condition(each, sqlExpression), this.shardingRule);
            if (insertStatement.getGenerateKeyColumnIndex() == count) {
                insertStatement.setGeneratedKey(this.createGeneratedKey(each, sqlExpression));
            }
            ++count;
        }
        this.lexerEngine.accept(Symbol.RIGHT_PAREN);
    }

    private GeneratedKey createGeneratedKey(Column column, SQLExpression sqlExpression) {
        GeneratedKey result;
        if (sqlExpression instanceof SQLPlaceholderExpression) {
            result = new GeneratedKey(column.getName(), ((SQLPlaceholderExpression)sqlExpression).getIndex(), null);
        } else if (sqlExpression instanceof SQLNumberExpression) {
            result = new GeneratedKey(column.getName(), -1, ((SQLNumberExpression)sqlExpression).getNumber());
        } else {
            throw new ShardingJdbcException("Generated key only support number.", new Object[0]);
        }
        return result;
    }

    private void parseMultipleValues(InsertStatement insertStatement) {
        insertStatement.getMultipleConditions().add(new Conditions(insertStatement.getConditions()));
        MultipleInsertValuesToken valuesToken = new MultipleInsertValuesToken(insertStatement.getAfterValuesPosition());
        valuesToken.getValues().add(this.lexerEngine.getInput().substring(insertStatement.getAfterValuesPosition(), this.lexerEngine.getCurrentToken().getEndPosition() - Symbol.COMMA.getLiterals().length()));
        while (this.lexerEngine.skipIfEqual(Symbol.COMMA)) {
            int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
            this.parseValues(insertStatement);
            insertStatement.getMultipleConditions().add(new Conditions(insertStatement.getConditions()));
            int endPosition = this.lexerEngine.equalAny(Symbol.COMMA) ? this.lexerEngine.getCurrentToken().getEndPosition() - Symbol.COMMA.getLiterals().length() : this.lexerEngine.getCurrentToken().getEndPosition();
            valuesToken.getValues().add(this.lexerEngine.getInput().substring(beginPosition, endPosition));
        }
        insertStatement.getSqlTokens().add(valuesToken);
    }
}

