/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.sql.ddl.drop;

import io.shardingjdbc.core.constant.DatabaseType;
import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.parser.dialect.mysql.sql.MySQLDropParser;
import io.shardingjdbc.core.parsing.parser.dialect.oracle.sql.OracleDropParser;
import io.shardingjdbc.core.parsing.parser.dialect.postgresql.sql.PostgreSQLDropParser;
import io.shardingjdbc.core.parsing.parser.dialect.sqlserver.sql.SQLServerDropParser;
import io.shardingjdbc.core.parsing.parser.sql.ddl.drop.AbstractDropParser;
import io.shardingjdbc.core.rule.ShardingRule;

public final class DropParserFactory {
    public static AbstractDropParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLDropParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleDropParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerDropParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLDropParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private DropParserFactory() {
    }
}

