/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.sql.dql.select;

import com.google.common.base.Optional;
import io.shardingjdbc.core.constant.AggregationType;
import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.lexer.token.Assist;
import io.shardingjdbc.core.parsing.lexer.token.DefaultKeyword;
import io.shardingjdbc.core.parsing.lexer.token.Symbol;
import io.shardingjdbc.core.parsing.parser.clause.facade.AbstractSelectClauseParserFacade;
import io.shardingjdbc.core.parsing.parser.context.OrderItem;
import io.shardingjdbc.core.parsing.parser.context.selectitem.AggregationSelectItem;
import io.shardingjdbc.core.parsing.parser.context.selectitem.SelectItem;
import io.shardingjdbc.core.parsing.parser.sql.SQLParser;
import io.shardingjdbc.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingjdbc.core.parsing.parser.token.ItemsToken;
import io.shardingjdbc.core.parsing.parser.token.OrderByToken;
import io.shardingjdbc.core.rule.ShardingRule;
import java.beans.ConstructorProperties;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractSelectParser
implements SQLParser {
    private static final String DERIVED_COUNT_ALIAS = "AVG_DERIVED_COUNT_%s";
    private static final String DERIVED_SUM_ALIAS = "AVG_DERIVED_SUM_%s";
    private static final String ORDER_BY_DERIVED_ALIAS = "ORDER_BY_DERIVED_%s";
    private static final String GROUP_BY_DERIVED_ALIAS = "GROUP_BY_DERIVED_%s";
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final AbstractSelectClauseParserFacade selectClauseParserFacade;
    private final List<SelectItem> items = new LinkedList<SelectItem>();

    @Override
    public final SelectStatement parse() {
        SelectStatement result = this.parseInternal();
        if (result.containsSubQuery()) {
            result = result.mergeSubQueryStatement();
        }
        this.appendDerivedColumns(result);
        this.appendDerivedOrderBy(result);
        return result;
    }

    private SelectStatement parseInternal() {
        SelectStatement result = new SelectStatement();
        this.lexerEngine.nextToken();
        this.parseInternal(result);
        return result;
    }

    protected abstract void parseInternal(SelectStatement var1);

    protected final void parseDistinct() {
        this.selectClauseParserFacade.getDistinctClauseParser().parse();
    }

    protected final void parseSelectList(SelectStatement selectStatement, List<SelectItem> items) {
        this.selectClauseParserFacade.getSelectListClauseParser().parse(selectStatement, items);
    }

    protected final void parseFrom(SelectStatement selectStatement) {
        this.lexerEngine.unsupportedIfEqual(DefaultKeyword.INTO);
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.FROM)) {
            this.parseTable(selectStatement);
        }
    }

    private void parseTable(SelectStatement selectStatement) {
        if (this.lexerEngine.skipIfEqual(Symbol.LEFT_PAREN)) {
            selectStatement.setSubQueryStatement(this.parseInternal());
            if (this.lexerEngine.equalAny(DefaultKeyword.WHERE, Assist.END)) {
                return;
            }
        }
        this.selectClauseParserFacade.getTableReferencesClauseParser().parse(selectStatement, false);
    }

    protected final void parseWhere(ShardingRule shardingRule, SelectStatement selectStatement, List<SelectItem> items) {
        this.selectClauseParserFacade.getWhereClauseParser().parse(shardingRule, selectStatement, items);
    }

    protected final void parseGroupBy(SelectStatement selectStatement) {
        this.selectClauseParserFacade.getGroupByClauseParser().parse(selectStatement);
    }

    protected final void parseHaving() {
        this.selectClauseParserFacade.getHavingClauseParser().parse();
    }

    protected final void parseOrderBy(SelectStatement selectStatement) {
        this.selectClauseParserFacade.getOrderByClauseParser().parse(selectStatement);
    }

    protected final void parseSelectRest() {
        this.selectClauseParserFacade.getSelectRestClauseParser().parse();
    }

    private void appendDerivedColumns(SelectStatement selectStatement) {
        ItemsToken itemsToken = new ItemsToken(selectStatement.getSelectListLastPosition());
        this.appendAvgDerivedColumns(itemsToken, selectStatement);
        this.appendDerivedOrderColumns(itemsToken, selectStatement.getOrderByItems(), ORDER_BY_DERIVED_ALIAS, selectStatement);
        this.appendDerivedOrderColumns(itemsToken, selectStatement.getGroupByItems(), GROUP_BY_DERIVED_ALIAS, selectStatement);
        if (!itemsToken.getItems().isEmpty()) {
            selectStatement.getSqlTokens().add(itemsToken);
        }
    }

    private void appendAvgDerivedColumns(ItemsToken itemsToken, SelectStatement selectStatement) {
        int derivedColumnOffset = 0;
        for (SelectItem each : selectStatement.getItems()) {
            if (!(each instanceof AggregationSelectItem) || AggregationType.AVG != ((AggregationSelectItem)each).getType()) continue;
            AggregationSelectItem avgItem = (AggregationSelectItem)each;
            String countAlias = String.format(DERIVED_COUNT_ALIAS, derivedColumnOffset);
            AggregationSelectItem countItem = new AggregationSelectItem(AggregationType.COUNT, avgItem.getInnerExpression(), (Optional<String>)Optional.of((Object)countAlias));
            String sumAlias = String.format(DERIVED_SUM_ALIAS, derivedColumnOffset);
            AggregationSelectItem sumItem = new AggregationSelectItem(AggregationType.SUM, avgItem.getInnerExpression(), (Optional<String>)Optional.of((Object)sumAlias));
            avgItem.getDerivedAggregationSelectItems().add(countItem);
            avgItem.getDerivedAggregationSelectItems().add(sumItem);
            itemsToken.getItems().add(countItem.getExpression() + " AS " + countAlias + " ");
            itemsToken.getItems().add(sumItem.getExpression() + " AS " + sumAlias + " ");
            ++derivedColumnOffset;
        }
    }

    private void appendDerivedOrderColumns(ItemsToken itemsToken, List<OrderItem> orderItems, String aliasPattern, SelectStatement selectStatement) {
        int derivedColumnOffset = 0;
        for (OrderItem each : orderItems) {
            if (this.isContainsItem(each, selectStatement)) continue;
            String alias = String.format(aliasPattern, derivedColumnOffset++);
            each.setAlias((Optional<String>)Optional.of((Object)alias));
            itemsToken.getItems().add((String)each.getQualifiedName().get() + " AS " + alias + " ");
        }
    }

    private boolean isContainsItem(OrderItem orderItem, SelectStatement selectStatement) {
        if (selectStatement.isContainStar()) {
            return true;
        }
        for (SelectItem each : selectStatement.getItems()) {
            if (-1 != orderItem.getIndex()) {
                return true;
            }
            if (each.getAlias().isPresent() && orderItem.getAlias().isPresent() && ((String)each.getAlias().get()).equalsIgnoreCase((String)orderItem.getAlias().get())) {
                return true;
            }
            if (each.getAlias().isPresent() || !orderItem.getQualifiedName().isPresent() || !each.getExpression().equalsIgnoreCase((String)orderItem.getQualifiedName().get())) continue;
            return true;
        }
        return false;
    }

    private void appendDerivedOrderBy(SelectStatement selectStatement) {
        if (!selectStatement.getGroupByItems().isEmpty() && selectStatement.getOrderByItems().isEmpty()) {
            selectStatement.getOrderByItems().addAll(selectStatement.getGroupByItems());
            selectStatement.getSqlTokens().add(new OrderByToken(selectStatement.getGroupByLastPosition()));
        }
    }

    @ConstructorProperties(value={"shardingRule", "lexerEngine", "selectClauseParserFacade"})
    public AbstractSelectParser(ShardingRule shardingRule, LexerEngine lexerEngine, AbstractSelectClauseParserFacade selectClauseParserFacade) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.selectClauseParserFacade = selectClauseParserFacade;
    }

    protected ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    protected LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }

    protected AbstractSelectClauseParserFacade getSelectClauseParserFacade() {
        return this.selectClauseParserFacade;
    }

    protected List<SelectItem> getItems() {
        return this.items;
    }
}

