/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.sql.dql.select;

import io.shardingjdbc.core.constant.DatabaseType;
import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.parser.dialect.mysql.sql.MySQLSelectParser;
import io.shardingjdbc.core.parsing.parser.dialect.oracle.sql.OracleSelectParser;
import io.shardingjdbc.core.parsing.parser.dialect.postgresql.sql.PostgreSQLSelectParser;
import io.shardingjdbc.core.parsing.parser.dialect.sqlserver.sql.SQLServerSelectParser;
import io.shardingjdbc.core.parsing.parser.sql.dql.select.AbstractSelectParser;
import io.shardingjdbc.core.rule.ShardingRule;

public final class SelectParserFactory {
    public static AbstractSelectParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLSelectParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleSelectParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerSelectParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLSelectParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private SelectParserFactory() {
    }
}

